/*----------------------------------------------+
| gfx							Florian Hufsky	|
|												|
| start:		14.12.2003						|
| last changes:	19.01.2004						|
+----------------------------------------------*/
/*--------------------------------------------------------------+
| gfx															|
|																|
| a stripped down version of tfree/free  for a pixelate article	|
|																|
| gfx is a mini graphics library containing						|
|  + initialisation of SDL										|
|  + a class for simple Sprites									|
|  + a class for animated Sprites								|
|																|
| have a lot of fun!											|
|					 2003 Florian Hufsky <fhufsky@phorus.at>	|
+--------------------------------------------------------------*/

#ifndef __GFX_H__
#define __GFX_H__


#include <SDL.h>


bool gfx_init(int w, int h, bool fullscreen);


class gfxSprite{
	public:
		gfxSprite();
		~gfxSprite();

		bool init(const char *filename, Uint8 r, Uint8 g, Uint8 b);	//color keyed
		bool init(const char *filename);							//non color keyed

		bool draw(int x, int y);


		int getWidth(){return m_picture->w;};
		int getHeight(){return m_picture->h;};

	private:
		SDL_Surface *m_picture;
		SDL_Rect m_bltrect;
};



class gfxAnimSprite{
	public:
		gfxAnimSprite();
		~gfxAnimSprite();

		bool init(const char *filename, Uint8 r, Uint8 g, Uint8 b, int picwidth, int picheight, Uint32 delay);
		
		bool draw(int x, int y);
		bool draw(int x, int y, int PicNum);

		int getWidth(){return m_picrect.w;};
		int getHeight(){return m_picrect.h;};
		unsigned int getPC(){return (unsigned int)m_piccount;}; //by Z-Man

	private:
		SDL_Surface *m_picture;
		SDL_Rect m_bltrect;
		SDL_Rect m_picrect;

		int *m_xoffsets;
		int *m_yoffsets;

		Uint32 m_lastpicswitch;
		Uint32 m_delay;
		int m_currentpic;
		int m_piccount;
};



#endif

