

#include "gfx.h"


extern SDL_Surface *screen;



bool gfx_init(int w, int h, bool fullscreen){
	printf("init gfx\n");
	if( SDL_Init(SDL_INIT_VIDEO) < 0 ) {
        printf("Couldn't initialize SDL: %s\n", SDL_GetError());
        return false;
    }

    /* Clean up on exit */
    atexit(SDL_Quit);
    
    if(fullscreen)
		screen = SDL_SetVideoMode(w, h, 0, SDL_SWSURFACE | SDL_FULLSCREEN);
	else
		screen = SDL_SetVideoMode(w, h, 0, SDL_SWSURFACE);

    if ( screen == NULL ) {
        printf("Couldn't set video mode %dx%d: %s\n", w, h, SDL_GetError());
		return false;
    }
    printf(" running @ %dx%d %dbpp\n", w,h,screen->format->BitsPerPixel);	

	printf(" done\n\n");
	return true;
}



gfxSprite::gfxSprite(){
	m_bltrect.x = 0;
	m_bltrect.y = 0;
	m_bltrect.w = 0;
	m_bltrect.h = 0;
	m_picture = NULL;
}

gfxSprite::~gfxSprite(){
	//free the allocated BMP surface 
	//--- i get an error if i delete the surface retrieved from SDL_DisplayFormat() - fix somewhen
	//SDL_FreeSurface(m_picture);
}

bool gfxSprite::init(const char *filename, Uint8 r, Uint8 g, Uint8 b){
	printf("loading sprite %s\n", filename);

    // Load the BMP file into a surface
    //m_picture = IMG_Load(filename);
	m_picture = SDL_LoadBMP(filename);

    if (m_picture == NULL) {
		printf("Couldn't load %s: %s\n", filename, SDL_GetError());
        return false;
    }

	if( SDL_SetColorKey(m_picture, SDL_SRCCOLORKEY | SDL_RLEACCEL, SDL_MapRGB(m_picture->format, r, g, b)) < 0){
		printf("Couldn't set ColorKey + RLE for %s: %s\n", filename, SDL_GetError());
		return false;
	}

	SDL_Surface *temp;
	if( (temp = SDL_DisplayFormat(m_picture)) == NULL){
		printf("couldn't convert %s to display format: %s\n", filename, SDL_GetError());
		return false;
	}
	SDL_FreeSurface(m_picture);
	m_picture = temp;


	m_bltrect.w = m_picture->w;
	m_bltrect.h = m_picture->h;

	printf(" done\n");
	return true;
}

bool gfxSprite::init(const char *filename) {
	printf("loading sprite %s\n", filename);

    // Load the BMP file into a surface
	m_picture = SDL_LoadBMP(filename);

    if (m_picture == NULL) {
		printf("Couldn't load %s: %s\n", filename, SDL_GetError());
        return false;
    }

	SDL_Surface *temp;
	if( (temp = SDL_DisplayFormat(m_picture)) == NULL){
		printf("couldn't convert %s to display format: %s\n", filename, SDL_GetError());
		return false;
	}
	SDL_FreeSurface(m_picture);
	m_picture = temp;


	m_bltrect.w = m_picture->w;
	m_bltrect.h = m_picture->h;

	printf(" done\n");
	return true;
}





bool gfxSprite::draw(int x, int y){
	m_bltrect.x = x;
	m_bltrect.y = y;

	// Blit onto the screen surface
	if(SDL_BlitSurface(m_picture, NULL, screen, &m_bltrect) < 0){
		fprintf(stderr, "BlitSurface error: %s\n", SDL_GetError());
		return false;
	}
	

	return true;
}




bool gfxAnimSprite::init(const char *filename, Uint8 r, Uint8 g, Uint8 b, int picwidth, int picheight, Uint32 delay){
    // Load the BMP file into a surface
	printf("loading AnimSprite %s", filename);

	m_picture = SDL_LoadBMP(filename);

    if (m_picture == NULL) {
        printf("Couldn't load %s: %s\n", filename, SDL_GetError());
        return false;
    }

	if( SDL_SetColorKey(m_picture, SDL_SRCCOLORKEY | SDL_RLEACCEL, SDL_MapRGB(m_picture->format, r, g, b)) < 0){
		printf("Couldn't set ColorKey + RLE for %s: %s", filename, SDL_GetError());
		return false;
	}

	SDL_Surface *temp;
	if( (temp = SDL_DisplayFormat(m_picture)) == NULL){
		printf("couldn't convert %s to display format: %s", filename, SDL_GetError());
		return false;
	}
	SDL_FreeSurface(m_picture);
	m_picture = temp;


	m_bltrect.w = picwidth;
	m_bltrect.h = picheight;

	m_picrect.w = picwidth;
	m_picrect.h = picheight;

	m_lastpicswitch = SDL_GetTicks();
	m_delay = delay;

	int i, j, k, piccount_hor, piccount_vert;

	piccount_hor	= ((m_picture->w)-1) / (picwidth+1);
	piccount_vert	= ((m_picture->h)-1) / (picheight+1);

	m_piccount	= piccount_hor*piccount_vert;
	m_currentpic = 0;

	k=0;//bilder index

	m_xoffsets = new int[m_piccount];
	m_yoffsets = new int[m_piccount];

	printf("done loading, calculating offsets");

	if(m_xoffsets == NULL || m_yoffsets == NULL){
		printf("couldn't get memory for x/y offsets for %s!\n", filename);
		return false;
	}

	//offsets fr die sub bilder festlegen (zwischen den bilder befindet sich 1px rand, um alle bilder ist auch 1px rand
	for(i=0; i<piccount_vert; i++){
		for(j=0; j<piccount_hor; j++){
			m_yoffsets[k] = 1 + (1+picheight)*i;
			m_xoffsets[k] = 1 + (1+picwidth)*j;

			k++;
		}
	}


	m_picrect.x = m_xoffsets[0];
	m_picrect.y = m_yoffsets[0];

	printf("done - load AnimSprite");
	return true;
}


gfxAnimSprite::~gfxAnimSprite(){
	if(m_xoffsets != NULL)
		delete [] m_xoffsets;
	if(m_yoffsets != NULL)
		delete [] m_yoffsets;
}

gfxAnimSprite::gfxAnimSprite(){
	m_picture		= NULL;
	m_bltrect.x		= 0;
	m_bltrect.y		= 0;
	m_bltrect.w		= 0;
	m_bltrect.h		= 0;
	m_picrect.x		= 0;
	m_picrect.y		= 0;;
	m_picrect.w		= 0;;
	m_picrect.h		= 0;;

	m_xoffsets		= NULL;
	m_yoffsets		= NULL;

	m_lastpicswitch	= 0;
	m_delay			= 0;
	m_currentpic		= 0;
	m_piccount		= 0;
}


bool gfxAnimSprite::draw(int x, int y){
	Uint32 tickcount;

	m_bltrect.x = x;
	m_bltrect.y = y;

	if(SDL_BlitSurface(m_picture, &m_picrect, screen, &m_bltrect) < 0){
		fprintf(stderr, "BlitSurface error: %s\n", SDL_GetError());
		return false;
	}



	if( ((tickcount=SDL_GetTicks()) - m_lastpicswitch) >= m_delay){
		m_currentpic += (tickcount-m_lastpicswitch)/m_delay;

		if(m_currentpic >= m_piccount){
			m_currentpic = m_currentpic % m_piccount;
		}

		m_lastpicswitch=tickcount;

		m_picrect.x = m_xoffsets[m_currentpic];
		m_picrect.y = m_yoffsets[m_currentpic];
	}

	return true;
}


bool gfxAnimSprite::draw(int x, int y, int PicNum){
	m_bltrect.x = x;
	m_bltrect.y = y;

	SDL_Rect r;
	r.x = m_xoffsets[PicNum%m_piccount];
	r.y = m_xoffsets[PicNum%m_piccount];
	r.w = m_picrect.w;
	r.h = m_picrect.h;

	if(SDL_BlitSurface(m_picture, &r, screen, &m_bltrect) < 0){
		fprintf(stderr, "BlitSurface error: %s\n", SDL_GetError());
		return false;
	}

	return true;
}