/*----------------------------------------------------------+
| jnrdev #1 leveleditor										|
|															|
| level editor for the jnrde #1 example game				|
|															|
| ...a big bunch of crappy code ;)							|
|															|
|															|
| this sourcecode is released under the GPL.				|
|															|
| start:		18.12.2003									|
| last changes:	22.12.2003									|
|															|
|				 2003 Florian Hufsky <fhufsky@phorus.at>	|
+----------------------------------------------------------*/


#include "../gfx.h"	//+sdl.h


#define TXMAX 32
#define TYMAX 24
#define TILESIZE 20


enum TileType{t_nonsolid, t_solid, t_slopeleft, t_sloperight};

struct CTile{
	TileType	type;
	gfxSprite	*spr;

	CTile(){
		type = t_nonsolid;
		spr = NULL;
	};

	void set(TileType ntype, gfxSprite *nspr){
		type = ntype;
		spr = nspr;
	};
};



SDL_Surface		*screen;
SDL_Event		event;

gfxSprite		spr_t[7];
gfxSprite		spr_background;
gfxSprite		spr_solid;
gfxSprite		spr_sloper;
gfxSprite		spr_slopel;

bool			done = false;

TileType		solidset = t_nonsolid;
gfxSprite		*sprset = NULL;


CTile tiles[TXMAX][TYMAX];




//main main main
int main(int argc, char *argv[]){
	int i, j, t, k;


	//init some stuff
	gfx_init(640,480, false);

	spr_t[0].init("../gfx/t1.bmp");
	spr_t[1].init("../gfx/t2.bmp");
	spr_t[2].init("../gfx/t3.bmp", 255,0, 255);
	spr_t[3].init("../gfx/tsloper.bmp", 255, 0, 255);
	spr_t[4].init("../gfx/tslopel.bmp", 255, 0, 255);
	spr_t[5].init("../gfx/t6.bmp", 255, 0, 255);
	spr_t[6].init("../gfx/t7.bmp", 255, 0, 255);
	spr_background.init("../gfx/bg.bmp");
	spr_solid.init("solid.bmp");
	spr_sloper.init("sloper.bmp");
	spr_slopel.init("slopel.bmp");


	//read the map file
	FILE *mapfile;

	mapfile = fopen("../maps/map01.map", "rb");

	for(j = 0; j < TYMAX; j++){
		for(i = 0; i < TXMAX; i++){
			//read solid
			fread(&(tiles[i][j].type), sizeof(TileType), 1, mapfile);
			//read tile
			fread(&t, sizeof(int), 1, mapfile);

			if(t != 128)
				tiles[i][j].spr = &spr_t[t];
		}
	}
	fclose(mapfile);


	printf("\nentering game loop...\n") ;
	while (!done){

		//handle messages
			while(SDL_PollEvent(&event)){
				switch(event.type){
					case SDL_QUIT:
						done = true;
					break;

					case SDL_KEYDOWN:
						if (event.key.keysym.sym == SDLK_ESCAPE)
							done = true;

					break;

					case SDL_MOUSEBUTTONDOWN:
						if(event.button.button == SDL_BUTTON_LEFT){
							CTile &t = tiles[event.button.x / TILESIZE][event.button.y / TILESIZE];
							
							
							if(t.spr == NULL){
								sprset = &spr_t[0];
							}
							else if(t.spr == &spr_t[6]){
								sprset = NULL;
							}
							else{
								for(k=0;k<6;k++){
									if(t.spr == &spr_t[k]){
										sprset = &spr_t[k+1];
									}
								}
							}

							t.spr = sprset;

						}
						else if(event.button.button == SDL_BUTTON_RIGHT){
							CTile &t = tiles[event.button.x / TILESIZE][event.button.y / TILESIZE];
							if(t.type == t_nonsolid)
								solidset = t_solid;
							else if(t.type == t_solid)
								solidset = t_sloperight;
							else if(t.type == t_sloperight)
								solidset = t_slopeleft;
							else if(t.type == t_slopeleft)
								solidset = t_nonsolid;

							t.type = solidset;
						}
					break;

					case SDL_MOUSEMOTION:
						if(event.motion.state == SDL_BUTTON(SDL_BUTTON_LEFT)){
							CTile &t = tiles[event.motion.x / TILESIZE][event.motion.y / TILESIZE];
							t.spr = sprset;
						}
						else if(event.motion.state == SDL_BUTTON(SDL_BUTTON_RIGHT)){
							CTile &t = tiles[event.motion.x / TILESIZE][event.motion.y / TILESIZE];
							t.type = solidset;
						}
					break;

					default:
					break;
				}
			}


		//draw the map
		spr_background.draw(0,0);
		for(i = 0; i < TXMAX; i++){
			for(j = 0; j < TYMAX; j++){
				if(tiles[i][j].spr != NULL)
					tiles[i][j].spr->draw(i*TILESIZE, j*TILESIZE);
				
				switch(tiles[i][j].type){
				case t_nonsolid:
					break;
					
				case t_solid:
					spr_solid.draw(i*TILESIZE,j*TILESIZE);
					break;
					
				case t_sloperight:
					spr_sloper.draw(i*TILESIZE,j*TILESIZE);
					break;

				case t_slopeleft:
					spr_slopel.draw(i*TILESIZE,j*TILESIZE);
				break;

				default:break;
				}
			}
		}

		
		SDL_Flip(screen);
	}

	


	//write the map

	FILE *outp;

	outp = fopen("../maps/map01.map", "wb");

	for(j = 0; j < TYMAX; j++){
		for(i = 0; i < TXMAX; i++){
			//write solid
			fwrite(&(tiles[i][j].type), sizeof(TileType), 1, outp);

			t = 128;
			//write tile
			for(k=0;k<7;k++){
				if(tiles[i][j].spr == &spr_t[k])
					t=k;
			}

			fwrite(&t, sizeof(int), 1, outp);

		}
	}
	fclose(outp);



	return 0;
}