#pragma once

namespace NTextFinder {
namespace NativeLib {
namespace JCodeUtil {

    enum Encoding {
        ENC_NONE,
        ENC_ASCII,
        ENC_SJIS,
        ENC_JIS,
        ENC_EUC,
        ENC_UTF8,
        ENC_UNICODE,
    };

    struct SCodeState {
        int binary;
        int ucs2;
        int sjis;
        int euc;
        int utf8;

        SCodeState( int b, int u2, int s, int e, int u8 ) : binary( b ), ucs2( u2 ), sjis( s ), euc( e ), utf8( u8 ) {}
    };

    Encoding GetEncoding( SCodeState& state, const unsigned char* buf, int begin, int end, int end_buf );

}
}
}
