﻿using System;
using System.Drawing;
using System.Windows.Forms;
using TabTextFinder.Properties;

namespace TabTextFinder
{
    partial class ConfigForm : Form
    {
        public string EditorCommand { get; set; }
        public string EditorArgument { get; set; }
        public bool WrapLines { get; set; }
        public bool WrapWords { get; set; }
        public bool EnableFileCache { get; set; }
        public long SizeFileCache { get; set; }

        private Orientation layout { get { return (btnLayoutVert.Checked) ? Orientation.Vertical : Orientation.Horizontal; } }

        public ConfigForm()
        {
            InitializeComponent();
            Icon = Icon.FromHandle( Resources.Img_wrench_screwdriver.GetHicon() );

            textEditorCommand.DataBindings.Add( "Text", this, "EditorCommand" );
            textEditorArgument.DataBindings.Add( "Text", this, "EditorArgument" );
            chkWrapLines.DataBindings.Add( "Checked", this, "WrapLines" );
            chkWrapWords.DataBindings.Add( "Checked", this, "WrapWords" );
            chkCacheFile.DataBindings.Add( "Checked", this, "EnableFileCache" );
            textCacheSize.DataBindings.Add( "Text", this, "SizeFileCache" );
        }

        public void LoadSettings( Settings settings )
        {
            EditorCommand = settings.EditorCommand;
            EditorArgument = settings.EditorArgument;
            WrapLines = settings.WrapLines;
            WrapWords = settings.WrapWords;
            EnableFileCache = settings.CheckFileCache;
            SizeFileCache = settings.SizeFileCache;
            btnLayoutVert.Checked = (settings.SplitOrientation == Orientation.Vertical);
            btnLayoutHorz.Checked = (settings.SplitOrientation == Orientation.Horizontal);
        }

        public void SaveSettings( Settings settings )
        {
            settings.EditorCommand = EditorCommand;
            settings.EditorArgument = EditorArgument;
            settings.WrapLines = WrapLines;
            settings.WrapWords = WrapWords;
            settings.CheckFileCache = EnableFileCache;
            settings.SizeFileCache = SizeFileCache;
            settings.SplitOrientation = layout;
        }

        public bool SettingsChanged( Settings settings )
        {
            return settings.EditorCommand != EditorCommand
                || settings.EditorArgument != EditorArgument
                || settings.WrapLines != WrapLines
                || settings.WrapWords != WrapWords
                || settings.CheckFileCache != EnableFileCache
                || settings.SizeFileCache != SizeFileCache
                || settings.SplitOrientation != layout;
        }

        private void ConfigForm_Load( object sender, EventArgs e )
        {
            UpdateControls();
        }


        private void chkWrapLines_CheckedChanged( object sender, EventArgs e )
        {
            UpdateControls();
        }

        private void chkCacheFile_CheckedChanged( object sender, EventArgs e )
        {
            UpdateControls();
        }

        private void UpdateControls()
        {
            {// text wrap
                chkWrapWords.Enabled = chkWrapLines.Checked;
                if (chkWrapLines.Checked) {
                    //azuki.ViewWidth = azuki.ClientSize.Width;
                }
                //azuki.ViewType = (chkWrapLines.Checked) ? ViewType.WrappedProportional : ViewType.Proportional;
                {// wrap words
                    bool bEnabled = chkWrapLines.Checked && chkWrapWords.Checked;
                }
            }
            {// file cache
                bool bEnable = chkCacheFile.Checked;
                textCacheSize.Enabled = bEnable;
                labelCacheSize.Enabled = bEnable;
                labelCacheSizeUnit.Enabled = bEnable;
            }
        }

        private void btnBrowse_Click( object sender, EventArgs e )
        {
            using (OpenFileDialog dlg = new OpenFileDialog()) {
                if (dlg.ShowDialog( this ) == DialogResult.OK) {
                    EditorCommand = dlg.FileName;
                    textEditorCommand.DataBindings["Text"].ReadValue();
                }
            }
        }
    }
}
