#pragma once

#include <vector>

namespace NTextFinder {
namespace NativeLib {
namespace BMUtil {

    struct SFindParams {
        const wchar_t* text;
        const wchar_t* content;
        int text_length;
        int content_length;
        const int* skip;
        const int* last_idx_of;
        const unsigned char* is_word;

    };

    struct SFoundLine {
        SFoundLine( int line, int begin, int length, int index )
            : line( line ), begin( begin), length( length ), index( index ) {}

        int line;
        int begin;
        int length;
        int index;
    };

    // @return number of lines
    int FindInLinesNative( const SFindParams& params, std::vector<SFoundLine>& FoundLines );

}
}
}
