#include "stdafx.h"

#include "JCodeAnalyzer.h"
#include "NativeLib/JCodeUtil.h"

using namespace System;
using namespace System::Text;

namespace NTextFinder {
namespace Native {

    JCodeAnalyzer::JCodeAnalyzer()
    {
        Reset();
    }

    void JCodeAnalyzer::Reset()
    {
        binary = 0;
        ucs2 = 0;
        sjis = 0;
        euc = 0;
        utf8 = 0;
    }

    Encoding^ JCodeAnalyzer::UpdateStatistics( array<unsigned char>^ buf, int begin, int end, int end_buf )
    {
        NativeLib::JCodeUtil::Encoding enc;
        {
            NativeLib::JCodeUtil::SCodeState state( binary, ucs2, sjis, euc, utf8 );
            {
                pin_ptr<unsigned char> _buf = PIN_PTR( buf );
                enc = NativeLib::JCodeUtil::GetEncoding( state, _buf, begin, end, end_buf );
            }
            binary = state.binary;
            ucs2   = state.ucs2;
            sjis   = state.sjis;
            euc    = state.euc;
            utf8   = state.utf8;
        }
        switch (enc) {
            case NativeLib::JCodeUtil::ENC_ASCII:     return Encoding::ASCII;
            case NativeLib::JCodeUtil::ENC_SJIS:      return Encoding::GetEncoding( 932 );
            case NativeLib::JCodeUtil::ENC_JIS:       return Encoding::GetEncoding( 50220 );
            case NativeLib::JCodeUtil::ENC_EUC:       return Encoding::GetEncoding( 51932 );
            case NativeLib::JCodeUtil::ENC_UTF8:      return Encoding::UTF8;
            case NativeLib::JCodeUtil::ENC_UNICODE:   return Encoding::Unicode;
        }
        return nullptr;
    }

    Encoding^ JCodeAnalyzer::GetEncoding()
    {
        if (euc > sjis && euc > utf8) {
            //EUC
            return Encoding::GetEncoding( 51932 );
        } else if (sjis > euc && sjis > utf8) {
            //SJIS
            return Encoding::GetEncoding( 932 );
        } else if (utf8 > euc && utf8 > sjis) {
            //UTF8
            return Encoding::UTF8;
        }
        return Encoding::Default;
    }

}
}
