#!/usr/bin/env python
import sys
from PyQt4 import QtCore, QtGui, uic

form_class, base_class = uic.loadUiType("searchWidget.ui")
class TwitturnSearchWidget(base_class, form_class):
    def __init__(self, *args):
        base_class.__init__(self, *args)

        self.setupUi(self)

        self.settings = QtCore.QSettings("Twitturn")
        self.connectActions()

        self.loadSettings()
        self.lineEdit.setFocus()

    def connectActions(self):
        pass

    def closeEvent(self, event):
        self.saveSettings()

    def loadSettings(self):
        if not self.settings.contains("onceSearched"): return
        self.settings.beginGroup("searchBox")
        self.radioButtonNick.setChecked(
                self.settings.value("nick").toBool())
        self.radioButtonText.setChecked(
                self.settings.value("text").toBool())
        self.settings.endGroup()

    def saveSettings(self):
        self.settings.setValue("onceSearched", QtCore.QVariant(True))
        self.settings.beginGroup("searchBox")
        self.settings.setValue("nick",
                QtCore.QVariant(
                    self.radioButtonNick.isChecked()))
        self.settings.setValue("text",
                QtCore.QVariant(
                    self.radioButtonText.isChecked()))
        self.settings.endGroup()


if __name__=="__main__":
    app = QtGui.QApplication(sys.argv)
    form = TwitturnSearchWidget()
    form.show()
    app.exec_()
