form_class, base_class = uic.loadUiType(
        os.path.join("plugins","extractionConfigDialog.ui"))
class ExtractionConfigDialog(base_class, form_class):
    def __init__(self, *args):
        base_class.__init__(self, *args)

        self.setupUi(self)

        self.settings = QtCore.QSettings("Twitturn")
        self.connectActions()

        self.loadSettings()

    def connectActions(self):
        pass

    def accept(self):
        base_class.accept(self)
        self.saveSettings()

    def loadSettings(self):
        if not self.settings.contains("plugins/extractionTab1/configured"): 
            return
        self.settings.beginGroup("plugins/extractionTab1")
        self.comboBoxNick.setCurrentIndex(
                self.settings.value("comboBoxNick").toInt()[0])
        self.checkBoxNick.setChecked(
                self.settings.value("checkBoxNick").toBool())
        self.textEditNick.setText(
                self.settings.value("textEditNick").toString())
        self.comboBoxText.setCurrentIndex(
                self.settings.value("comboBoxText").toInt()[0])
        self.checkBoxText.setChecked(
                self.settings.value("checkBoxText").toBool())
        self.textEditText.setText(
                self.settings.value("textEditText").toString())
        self.settings.endGroup()

    def saveSettings(self):
        self.settings.setValue("plugins/extractionTab1/configured", 
                QtCore.QVariant(True))

        self.settings.beginGroup("plugins/extractionTab1")
        self.settings.setValue("comboBoxNick",
                QtCore.QVariant(self.comboBoxNick.currentIndex()))
        self.settings.setValue("checkBoxNick",
                QtCore.QVariant(self.checkBoxNick.isChecked()))
        self.settings.setValue("textEditNick",
                QtCore.QVariant(self.textEditNick.toPlainText()))
        self.settings.setValue("comboBoxText",
                QtCore.QVariant(self.comboBoxText.currentIndex()))
        self.settings.setValue("checkBoxText",
                QtCore.QVariant(self.checkBoxText.isChecked()))
        self.settings.setValue("textEditText",
                QtCore.QVariant(self.textEditText.toPlainText()))
        self.settings.endGroup()

def stringCompare(s1, s2, matchingType=0, cs=QtCore.Qt.CaseInsensitive):
    if matchingType==0:
        return s1 == s2
    elif matchingType==1:
        return s1.contains(s2, cs)
    elif matchingType == 2:
        return s1.startsWith(s2, cs)
    elif matchingType == 3:
        return s1.endsWith(s2, cs)
    elif matchingType == 4:
        return QtCore.QRegExp(s2,cs,QtCore.QRegExp.RegExp2).exactMatch(s1)
    elif matchingType == 5:
        return QtCore.QRegExp(s2,cs,QtCore.QRegExp.Wildcard).exactMatch(s1)

class ExstractTabFilter():
    def __init__(self):
        self.nickExt = []
        self.nickMatchingType = 0
        self.nickCaseSesnsitivity = QtCore.Qt.CaseInsensitive

        self.textExt = []
        self.textMatchingType = 0
        self.textCaseSesnsitivity = QtCore.Qt.CaseInsensitive

        self.settings = QtCore.QSettings("Twitturn")

        self.loadSettings()

    def filter(self, widget, post):
        for nick in self.nickExt:
            if stringCompare(
                    post.text(1),
                    nick, 
                    self.nickMatchingType,
                    self.nickCaseSesnsitivity):
                print "Nick: ", post.text(1), nick, self.nickMatchingType, self.nickCaseSesnsitivity
                widget.addPost(post, True)
                widget.setNotify(True)
                post.setForeground(
                        1, QtGui.QBrush(QtGui.QColor("darkmagenta")))
                post.setForeground(
                        2, QtGui.QBrush(QtGui.QColor("darkmagenta")))
                return
        for text in self.textExt:
            if stringCompare(
                    post.text(2),
                    text, 
                    self.textMatchingType,
                    self.textCaseSesnsitivity):
                widget.addPost(post, True)
                widget.setNotify(True)
                post.setForeground(
                        1, QtGui.QBrush(QtGui.QColor("darkblue")))
                post.setForeground(
                        2, QtGui.QBrush(QtGui.QColor("darkblue")))
                return
    def loadSettings(self):
        if not self.settings.contains("plugins/extractionTab1/configured"): 
            return
        self.settings.beginGroup("plugins/extractionTab1")

        self.nickMatchingType = self.settings.value("comboBoxNick").toInt()[0]
        if self.settings.value("checkBoxNick").toBool():
            self.nickCaseSesnsitivity = QtCore.Qt.CaseSensitive
        else:
            self.nickCaseSesnsitivity = QtCore.Qt.CaseInsensitive

        self.nickExt = self.settings.value("textEditNick").toString().split(
                "\n", 
                QtCore.QString.SkipEmptyParts)

        self.textMatchingType = self.settings.value("comboBoxText").toInt()[0]
        if self.settings.value("checkBoxText").toBool():
            self.textCaseSesnsitivity = QtCore.Qt.CaseSensitive
        else:
            self.textCaseSesnsitivity = QtCore.Qt.CaseInsensitive  
        self.textExt = self.settings.value("textEditText").toString().split(
                "\n",
                QtCore.QString.SkipEmptyParts)

        self.settings.endGroup()


    def popupExtractionSettingDialog(self, mouseEvent):
        if mouseEvent.button()== QtCore.Qt.RightButton:
            dialog = ExtractionConfigDialog(form)
            dialog.exec_()
            self.loadSettings()



exstractTabFilter = ExstractTabFilter()
tab = form.appendTab(form.tr("Extract&1"),
        exstractTabFilter.filter)
tab.treeWidget.mouseReleaseEvent = exstractTabFilter.popupExtractionSettingDialog
#menu_Extract = QtGui.QMenu(form.menubar)
#action_ConfigureTab1 = QtGui.QAction(form)
#menu_Extract.addAction(action_ConfigureTab1)
#form.menubar.addAction(menu_Extract.menuAction())
#menu_Extract.setTitle(form.tr("E&xtract"))
#action_ConfigureTab1.setText(form.tr("Configure Tab 1"))
#
#form.connect(action_ConfigureTab1,
#        QtCore.SIGNAL("triggered()"),
#        exstractTabFilter.popupExtractionSettingDialog)
