#!/usr/bin/env python

import sys, os

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtNetwork import *

import signal
signal.signal(signal.SIGINT, signal.SIG_DFL)

class IpcOutputClient(QObject):
    def __init__(self, parent=None):
        self.sock = QLocalSocket(parent)
        self.sock.readyRead.connect(self.read)
        self.sock.connected.connect(self.slotConnected)
        self.sock.disconnected.connect(self.slotDisconnected)

        timer = QTimer(parent)
        timer.setSingleShot(False)
        timer.setInterval(500)
        timer.timeout.connect(self.connectToTheServer)
        timer.start()
    def connectToTheServer(self):
        if self.sock.state() == QAbstractSocket.UnconnectedState:
            self.sock.connectToServer("twitturnIpcOutputServer")
    def slotConnected(self):
        print 'connected'
    def slotDisconnected(self):
        print 'disconnected'
    def read(self):
        print self.sock.readAll()

class IpcOutputClientGUI(QWidget, IpcOutputClient):
    def __init__(self, parent=None):
        QWidget.__init__(self, parent)
        IpcOutputClient.__init__(self, self)
        self.tweetsQueue = []

        self.textLabel = QLabel(self)

        self.dragPosition = QPoint()

        self.anim = QPropertyAnimation(self.textLabel, 'geometry')
        self.anim.finished.connect(self.tickerNext)

        quitAction = QAction(self.tr("E&xit"), self)
        quitAction.setShortcut(self.tr("Ctrl+Q"))
        quitAction.triggered.connect(app.quit)
        self.addAction(quitAction)
        self.setContextMenuPolicy(Qt.ActionsContextMenu)

        pl = self.palette()
        pl.setColor(QPalette.Background, Qt.black)
        pl.setColor(QPalette.Foreground, Qt.white)
        self.setPalette(pl)

    def mousePressEvent(self, event):
        if event.button() == Qt.LeftButton:
            self.dragPosition = event.globalPos() - self.frameGeometry().topLeft()
            event.accept()
    def mouseMoveEvent(self, event):
        if event.buttons() & Qt.LeftButton:
            self.move(event.globalPos() - self.dragPosition)
            event.accept()

    def tickerNext(self):
        if 0 < len(self.tweetsQueue):
            if not self.isVisible():
                self.show()
            text = self.tweetsQueue.pop(0) 
            self.textLabel.setFixedWidth(self.textLabel.fontMetrics().width(text))
            self.textLabel.setText(text)
            self.setStartValue(
                    self.width(), 0, 
                    self.textLabel.width(), self.textLabel.height()
                    )
            self.setEndValue(
                    self.width()+self.textLabel.widht(), 0, 
                    self.textLabel.width(), self.textLabel.height()
                    )
        else:
            if self.isVisible():
                self.hide()
    def read(self):
        self.tweetsQueue.append(QString.fromUtf8(self.sock.readAll()).replace('\n', '    '))
        if not self.anim.state == QAbstractAnimation.Running:
            self.tickerNext()

if __name__=="__main__":
    app = QApplication(sys.argv)
    client = IpcOutputClientGUI()
    client.setWindowFlags(
            Qt.ToolTip
            | Qt.FramelessWindowHint
            | Qt.WindowStaysOnTopHint
            | Qt.WindowSystemMenuHint
            )
    client.setWindowOpacity(0.8)
    client.resize(400,20)
    client.show()
    sys.exit(app.exec_())
