/**
 * @file bsp_bluetank.c
 * @author takemasa
 * @brief BlueTank ACB-BF592ボード用のリソース
 * @details
 * ここにはBSP専用のリソースを置く。実際にはボードの初期化子を置く。
 */
#include <s_services.h>
#include <t_services.h>
#include <cdefBF592-A.h>
#include <bsp_bluetank.h>

void board_initialize(VP_INT exinf)
{
    // ADSP-BF592 PORTG設定
    // DR0PRI, RSCK0, RFS0, TD0PRI, TSCK0, TSF0をMUXで0 ( Primary func )にする
    *pPORTG_MUX &= ~0x00ee;

    // ADSP-BF592 PORTG設定
    // DR0PRI, RSCK0, RFS0, TD0PRI, TSCK0, TSF0をFERでイネーブルにする
    *pPORTG_FER = 0x00ee;
}

