//----------------------------------------------------------------------
//
//			File:			"TextView.h"
//			Created:		01-Apr-2011
//			Author:			Nobuhide Tsuda
//			Description:	TextView NX錾
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2011 by Nobuhide Tsuda

	{\[XR[h͊{I MIT CZXɏ]B
	http://www.opensource.org/licenses/mit-license.php
	http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license

	A͕sRŎg̈ GPL 匙Ȃ̂ŁA
	GPL CZXvWFNg{\[X𗬗p邱Ƃւ

*/

#ifndef PLAINTEXTEDIT_H
#define PLAINTEXTEDIT_H

#define		LAIDOUT_BLOCKS_MGR		1
#define		LAZY_LAIDOUT			0

#include <deque>
#include <QAbstractScrollArea>
#include	"gap_vector.h"
#include	"textBlock.h"
#include	"textCursor.h"

class ViEngine;
class TextView;
class ViewCursor;
class TextDocument;
class DocCursor;
class DocBlock;
class LaidoutBlocksMgr;
//class QElapsedTimer;
class QTimer;

struct ViewLine
{
public:
	index_t	m_position;		//	sʒu
	index_t	m_blockIndex;	//	ubNCfbNX

public:
	ViewLine(index_t position, index_t blockIndex)
		: m_position(position), m_blockIndex(blockIndex)
		{}
};


#if 0
class ViewBlock : public DocBlock;
{
private:
	TextView	*m_view;
};
#endif

class TextView : public QAbstractScrollArea
{
	Q_OBJECT

public:
	TextView(QWidget *parent = 0);
	~TextView();

public:
	uchar	charEncoding() const;
	bool	withBOM() const;
	bool	isModified() const;
	bool	hasMultiCursor() const { return !m_multiCursor.empty(); }
	bool	lineBreakMode() const { return m_lineBreakMode; }
	QString	toPlainText() const;
	const TextDocument	*document() const { return m_document; }
	//size_t blockCount() const { return m_blocks.size(); }
	BlockData	docBlockData(BlockData) const;
	DocBlock	docBlock(BlockData) const;
	ViewBlock	findBlockByNumber(index_t) const;		//	ubNԍi0..*jubN擾
	BlockData	findBlockData(index_t position) const;
	BlockData	nextBlockData(BlockData d) const
	{
		return BlockData(d.m_index + 1, d.m_position + blockSize(d.m_index));
	}
	BlockData	prevBlockData(BlockData d) const
	{
		if( !d.m_index )
			return BlockData(INVALID_INDEX, 0);
		else {
			return BlockData(d.m_index - 1, d.m_position - blockSize(d.m_index - 1));
		}
	}
	size_t	size() const;	// { return document()->size(); }
	bool	isLayoutedDocBlock(index_t ix) const;
	bool	isLayoutedViewBlock(index_t ix) const;
	size_t	blockSize(index_t ix) const;	// { return m_blocks[ix].m_size; }
	size_t	blockCount() const;
	size_t	laidoutDocBlockCount() const;
#if !LAIDOUT_BLOCKS_MGR
	size_t	firstUnlayoutedBlockCount() const { return m_firstUnlayoutedBlockCount; }
	size_t	layoutedDocBlockCount() const { return m_layoutedDocBlockCount; }
#endif
#if 0
	index_t	firstViewLine() const { return m_firstViewLine; }
	index_t	lastViewLine() const { return m_lastViewLine; }
#endif
	int		charCountToX(const QString &, int) const;		//	Q͕
	int		xToCharCount(const QString &, int) const;		//	WɑΉ镶Ԃ
	index_t	movePositionByCharCount(index_t, int n) const;	//	n ړ
	BlockData cacheBlockData() const { return m_cacheBlockData; }
#if LAIDOUT_BLOCKS_MGR
	LaidoutBlocksMgr	*lbMgr() const { return m_lbMgr; }
#endif
	const ViewBlock *firstVisibleBlockPtr() const;
	const ViewBlock *lastVisibleBlockPtr() const;
	uchar	viMode() const { return m_viMode; }

public:
	TextDocument	*document() { return m_document; }
	void	clear();
	//void	setViEngine(ViEngine *);
	void	doJump(int lineNum);
	void	doVertScroll(int, int = 0);
	void	setOverwriteMode(bool);
	void	onFontChanged();
	void	clearSelection() { m_textCursor->clearSelection(); }
	void	clearMultiCursor() { m_multiCursor.clear(); }
	void	rotateSelectedText(std::vector<ViewCursor*> &);

	ViewCursor	textCursor() { return *m_textCursor; }
	ViewBlock	firstBlock() const;
	ViewBlock	lastBlock() const;
	ViewBlock	findBlock(index_t) const;

	void	getAllCursor(std::vector<ViewCursor*> &);
	void	setTextCursor(const ViewCursor &cur);
	void	setLineBreakMode(bool b) { onLineBreak(b); }

	void	doDelete(int, int);
	void	doOpenLine(bool next = true);		//	next = false Ȃ΁AOɍsI[v
	void	doUndo(int n = 1, bool vi = false);
	void	doRedo(int n = 1);

	void	deleteChar();
	void	deletePreviousChar();
	void	insertText(const QString &, bool = false);
	int		insertText(ViewCursor &, const QString &);
	size_t	deleteChar(ViewCursor &);
	size_t	deletePreviousChar(ViewCursor &);
	void	buildBlocks() { buildBlocks(firstBlock(), 0, 0); }
	void	addToMultiCursor();

public slots:
	void	copy();
	void	cut();
	void	paste();
	void	undo(bool vi = false);
	void	redo();
	void	selectAll();
	void	replace();
	void	find();
	void	findNext();
	void	findPrev();
	void	findCurWord();
	void	doFindNext(const QString &, ushort);
	void	isMatched(bool &, const QString &, ushort);
	void	doReplace(const QString &);
	void	doReplaceAll(const QString &, ushort, const QString &);
	void	setFontPointSize(int);
	void	setFontFamily(const QString &);
	void	makeFontBigger(bool);
	void	onLineBreak(bool);
	void	setViMode(uchar mode); //{ m_viMode = mode; }

protected:
	ViewBlock	yToTextBlock(int) const;
	int		textBlockToY(const ViewBlock&) const;		//	XN[lAblock YWԂ
														//	ʊȌꍇ -1 Ԃ
protected:
	bool	eventFilter(QObject *obj, QEvent *event);
	bool	event ( QEvent * event );
	void	paintEvent(QPaintEvent * event);
    void	keyPressEvent ( QKeyEvent * keyEvent );
    void	inputMethodEvent ( QInputMethodEvent * event );
	void	wheelEvent ( QWheelEvent * event );
    void	focusInEvent ( QFocusEvent * event );
    void	resizeEvent ( QResizeEvent * event );
    void	mousePressEvent ( QMouseEvent * event );
    void	mouseReleaseEvent ( QMouseEvent * event );
    void	mouseMoveEvent ( QMouseEvent * event );
    void	mouseDoubleClickEvent ( QMouseEvent * event );
    QVariant	inputMethodQuery ( Qt::InputMethodQuery query ) const;
	void	drawCursor(QPainter &painter, const ViewCursor &, ViewBlock &,
						const QString &text, int y, const QColor &color);
	void	doPaint();
	void	drawNewline(QPainter &, int x, int y, const QString &, int ix);
	void	updateLineNumberAreaSize();
	void	updateScrollBarData();
	void	drawLineNumbers();
	void	resetCursorBlinkTimer();
	void	addToMultiCursor(const ViewCursor &cur) { m_multiCursor.push_back(cur); };
	void	ensureBlockLayout();
	void	updateBlocks();
	void	clearBlocks();
	void	eraseBlocks(index_t, index_t /*, size_t*/);
	void	buildBlocks(ViewBlock, int ht = 0, index_t = 0);
	//void	reLayoutBlocks(DocBlock, index_t lastPosition, index_t vbIndex);
	void	reLayoutBlocksUntillDocBlockNumber(DocBlock, index_t lastBlockNumber, index_t vbIndex);
	void	layoutText(std::vector<size_t> &, const DocBlock &, int wd, int tabWidth);
	void	layoutText(std::vector<size_t> &, const QString &, index_t, int wd, int tabWidth);
	void	getReLayoutRange(ViewCursor cur,
								DocBlock &block,		//	ăCAEgJnubN
								index_t &lastPosition,	//	ăCAEgIʒu [block, last)
								index_t &firstViewBlockNumber);	//	ăCAEgJnr[ubNԍ
								//index_t &lastViewBlockIndex);	//	ăCAEgIʒu [first, last)
	void	getReLayoutRangeByBlockNumber(ViewCursor cur,
								DocBlock &block,		//	ăCAEgJnubN
								index_t &lastBlockNumber,	//	ăCAEgIʒu [block, last)
								index_t &firstViewBlockNumber);	//	ăCAEgJnr[ubNԍ

	void	resetCursorBlink();
    void	removeOverlappedCursor();
    ViewBlock	firstVisibleBlock() const;
    void	ensureCursorVisible();
	int		lineNumberLength() const;			//	ősԍ

protected slots:
	void	layout100Blocks();				//	V100sCAEg
	void	onBlockCountChanged();
	void	onTimer();

signals:
	void	doLayout100Blocks();			//	100sCAEg
	void	printBuffer();
	void	showMessage(const QString &);
	void	doViCommand(const QString &);

private:
	bool	m_overwriteMode;				//	㏑[h
	bool	m_mouseCaptured;
	bool	m_mouseDoubleClicked;
	bool	m_toDeleteIMEPreeditText;
	bool	m_drawCursor;
	bool	m_lineBreakMode;					//	E[Ő܂Ԃ
	bool	m_lineBreaking;						//	܂Ԃ
	uchar	m_viMode;							//	CMD | INSERT | REPLACE | CMDLINE
	//ViEngine	*m_viEngine;
	ViewCursor	m_viewTextCursor;
	std::vector<ViewCursor>	m_multiCursor;		//	J[\Aposition L[ɏ\[gς݂Ƃ
													//	͏Ɖ肵 std::vector p
	ViewCursor	*m_preeditPosCursor;
	ViewCursor	*m_wordSelCursor;				//	PII͈
	QString	m_preeditString;
	TextDocument	*m_document;
	ViewCursor	*m_textCursor;					//	r[pJ[\
	mutable bool		m_validFirstVisibleBlock;		//	m_firstVisibleBlock L
	mutable size_t		m_firstVisibleDocBlockNumber;
	mutable BlockData	m_firstVisibleBlock;			//	\Jns
	int		m_viewportWidth;
	QWidget	*m_lineNumberArea;
	int		m_lineNumberAreaWidth;
	int		m_lineNumberWidth;
	//int		m_lineNumberNDigits;		//	
	QTimer	*m_timer;					//	^C}[IuWFNg
	//mutable std::gap_vector<ViewTextBlockItem>	m_blocks;		//	ubNz
	mutable BlockData	m_cacheBlockData;			//	JgubN

#if LAIDOUT_BLOCKS_MGR
	mutable LaidoutBlocksMgr	*m_lbMgr;
#else
	size_t	m_firstUnlayoutedBlockCount;		//	OCAEgDocBlock
	size_t	m_layoutedDocBlockCount;				//	CAEgςݍsDocBlock
	mutable std::gap_vector<uint>	m_blockSize;	//	CAEgςݍs̍s
#endif
#if 0
	size_t	m_firstViewLine;
	size_t	m_lastViewLine;
	mutable std::deque<ViewLine>	m_viewLines;
#endif

	friend void test_TextView();
	friend void test_LaidoutBlock();
};

#endif // PLAINTEXTEDIT_H
