//----------------------------------------------------------------------
//
//			File:			"MainWindow.h"
//			Created:		01-Apr-2011
//			Author:			Nobuhide Tsuda
//			Description:	MainWindow NX錾
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2011 by Nobuhide Tsuda

	{\[XR[h͊{I MIT CZXɏ]B
	http://www.opensource.org/licenses/mit-license.php
	http://sourceforge.jp/projects/opensource/wiki/licenses%2FMIT_license

	A͕sRŎg̈ GPL 匙Ȃ̂ŁA
	GPL CZXvWFNg{\[X𗬗p邱Ƃւ

*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include	"vi.h"
#include	"unit_test.h"

class QAction;
class QMenu;
class QTextEdit;
class TextView;
class ViEngine;
class QLineEdit;

class MainWindow : public QMainWindow
{
	Q_OBJECT

public:
	MainWindow(QWidget *parent = 0, Qt::WFlags flags = 0);
    MainWindow(const QString &fileName, QWidget *parent = 0, Qt::WFlags flags = 0);
	~MainWindow();

public:
	QStringList findStrings() const;		//{ return m_findStrings; }

public slots:
    void	doOutput(const QString &);
	void	printBuffer();

protected:
	bool	eventFilter(QObject *obj, QEvent *event);
    void closeEvent(QCloseEvent *event);
    MainWindow	*findMainWindow(const QString &fileName);
    void	updateWindowTitle();
    void	updateCurFile();
	bool	maybeSave();
	bool	saveFile(const QString &fileName, bool = true);
	void	loadFile(const QString &fileName, int lineNum = 1);
    void	setCurrentFile(const QString &fileName);
    void	updateRecentFileActions();
    QString strippedName(const QString &fullFileName);
	QString	findCommand(const QStringList cmds, const QString text, bool);

private:
    void init();
    void createActions();
    void createMenus();
    void createToolBars();
    void createStatusBar();
    void createDockWindows();
    void readSettings();
    void writeSettings();

private slots:
	void	onImeOpenStatusChanged();
	void	onModeChanged(Mode, ushort=0);
    void	documentWasModified();
	void	newFile();
	void	open();
	bool	save();
	bool	saveAs();
	//void	closeAll();
	void	reOpen();
	void	open(const QString &);
	void	save(const QString &);
    void	openRecentFile();
	void	doJump(int lineNum);
    void	showAboutDlg();
	void	cmdLineTextChanged(const QString & text);
	void	cmdLineReturnPressed();
	void	cmdLineCursorPositionChanged(int, int);
	void	setFocusToCmdLine();
	void	showMessage(const QString & text);
	void	font();
	void	viSupported(bool);
	void	doUnitTest();
	void	onUnitTestDoc(bool);
	void	onUnitTestView(bool);
	void	doBenchmark();
	void	onBenchmarkReplace(bool b);
	void	closeView(TextView*, bool = false);
	void	closeAllViews(bool = false);
	void	clearOutput();
	void	testViCommands(QString fileName);

private:
	TextView	*m_view;
	ViEngine	*m_viEngine;
	QLineEdit	*m_cmdLineEdit;
	int			m_exCmdsIx;
	QString		m_cmdText;			//	QLineEdit Ɏۂɓ͂ꂽeLXg
	QTextEdit	*m_output;
	QString	m_curFile;
	QString	m_absFilePath;
	QStringList	m_findStrings;		//	iK\j񗚗
	bool	m_isUntitled;
	bool	m_isModified;
	bool	m_unitTestDoc;
	bool	m_unitTestLaidoutBlocksMgr;
	bool	m_unitTestView;
	bool	m_benchmarkReplace;

	QDockWidget	*m_outputDock;
	QDockWidget	*m_telopDock;

    QMenu	*fileMenu;
    QMenu	*editMenu;
    QMenu	*searchMenu;
    QMenu	*viewMenu;
    QMenu	*settingsMenu;
    QMenu	*otherMenu;

	QAction *newAct;
	QAction *openAct;
	QAction *saveAct;
	QAction *saveAsAct;
	QAction *closeAllAct;
    QAction *selectAllAct;
    QAction *cutAct;
    QAction *copyAct;
    QAction *pasteAct;
    QAction *undoAct;
    QAction *redoAct;
    QAction *findAct;
    QAction *findNextAct;
    QAction *findPrevAct;
    QAction *findCurWordAct;	//	J[\ʒuPꌟ
    QAction *replaceAct;
    QAction *linebreakAct;		//	E[Ő܂Ԃ
    QAction *fontAct;			//	bI
    QAction *viSupportedAct;			//	bI
    QAction *aboutAct;

	QAction	*printBufferAct;
    QAction	*unitTestAct;
    QAction	*unitTestDocAct;
    QAction	*unitTestViewAct;
    QAction	*benchmarkAct;
    QAction	*benchmarkReplaceAct;

    QAction *separatorMRUAct;
    enum { MaxRecentFiles = 10 };
    QAction *recentFileActs[MaxRecentFiles];
};

#endif // MAINWINDOW_H
