//----------------------------------------------------------------------
//
//			File:			"textBlock.h"
//			Created:		22-Apr-2011
//			Author:			ÓcLG
//			Description:
//
//----------------------------------------------------------------------

#pragma once

#ifndef		_HEADER_TESTBLOCK_H
#define		_HEADER_TESTBLOCK_H

#include <QString>
#include	"gap_vector.h"

typedef size_t index_t;

#define		SIMPLE_LAIDOUT_BLOCKS	1
#define		BLOCK_HAS_SIZE		1
#define		INVALID_INDEX		0xffffffff

class TextDocument;
class TextView;
class LaidoutBlock;

//----------------------------------------------------------------------
struct BlockData
{
public:
	index_t		m_index;
	index_t		m_position;
public:
	BlockData(index_t index = 0, index_t position = 0)
		: m_index(index), m_position(position)
		{}

public:
	index_t index() const { return m_index; }
	index_t position() const { return m_position; }
};

class DocBlock
{
public:
	DocBlock(TextDocument *document, index_t blockNumber, index_t blockPosition)
		: m_document(document), m_data(BlockData(blockNumber, blockPosition))
		{}
	DocBlock(TextDocument *document, BlockData block)
		: m_document(document), m_data(block)
		{}
	DocBlock(const DocBlock &x)
		: m_document(x.m_document)
#if	BLOCK_HAS_SIZE
		, m_data(x.m_data)
#endif
		{}
	~DocBlock() {}

public:
	size_t		size() const;		//	s܂߂R[h
	size_t		length() const { return size(); }
	index_t		EOLOffset() const;
	size_t		newlineLength() const;		//	s̃oCgԂ
	size_t		newlineLength(index_t) const;		//	wʒuỎsoCgԂ
	bool		isValid() const;
	//{ return m_document != 0 && blockNumber() >= m_document->blockCount(); }
	index_t		index() const { return m_data.m_index; }
	index_t		blockNumber() const { return m_data.m_index; }
	index_t		position() const;	// { return isValid() ? m_document->blockPosition(m_index) : 0; }
	index_t		nextBlockPosition() const { return position() + size(); }
	BlockData	data() const { return m_data; }
	QString		text() const;
	int			charsCount(index_t) const;		//	swʒu܂ł̕Ԃ
	const TextDocument	*document() const { return m_document; }
	TextDocument	*document() { return m_document; }

	bool	operator==(const DocBlock &x) const
	{ return m_document == x.m_document && blockNumber() == x.blockNumber(); }
	bool	operator!=(const DocBlock &x) const
	{ return !this->operator==(x); }
	bool	operator<(const DocBlock &x) const
	{ return m_document == x.m_document && blockNumber() < x.blockNumber(); }

public:
	DocBlock	next() const;
	DocBlock	prev() const;

	DocBlock	&operator++();
	DocBlock	&operator--();

protected:
	TextDocument	*m_document;
	BlockData	m_data;
};

class ViewBlock : public DocBlock
{
public:
	ViewBlock(TextView *view, const DocBlock &, BlockData);

public:
	//index_t		index() const { return m_index; }
	bool		isFirstBlock() const;	//	DocBlock ̍ŏ̍sH
	bool		isLayouted() const;
	size_t		size() const;
	index_t		EOLOffset() const;
	index_t		position() const;
	index_t		docPosition() const { return DocBlock::position(); };
	index_t		docIndex() const { return DocBlock::index(); }
	index_t		docBlockNumber() const { return DocBlock::blockNumber(); }
	index_t		index() const { return m_viewBlock.m_index; }
	index_t		blockNumber() const { return m_viewBlock.m_index; }
	index_t		viewBlockNumber() const { return m_viewBlock.index(); }
	index_t		nextBlockPosition() const { return position() + size(); }
	BlockData	data() const { return m_viewBlock; }
	ViewBlock	next() const;
	ViewBlock	prev() const;
	QString		text() const;
	int			charsCount(index_t) const;		//	swʒu܂ł̕Ԃ
	const TextView	*view() const { return m_view; }

	bool	operator==(const ViewBlock &x) const
	{ return m_view == x.m_view && blockNumber() == x.blockNumber(); }
	bool	operator!=(const ViewBlock &x) const
	{ return !this->operator==(x); }
	bool	operator<(const ViewBlock &x) const
	{ return m_view == x.m_view && blockNumber() < x.blockNumber(); }

public:
	ViewBlock	&operator=(const DocBlock &);
	ViewBlock	&operator++();
	ViewBlock	&operator--();

protected:
	TextView	*m_view;
	BlockData	m_viewBlock;		//	m_position	sʒu
									//	m_index		r[sԍi0..*j
};

struct LaidoutChunk
{
	size_t	m_unLaidoutDocBlockCount;	//	s関CAEgubN
	size_t	m_laidoutDocBlockCount;		//	CAEgς݃hLgubN
	std::gap_vector<size_t>	m_blocks;	//	CAEgς݃ubNz

public:
	LaidoutChunk()
		: m_unLaidoutDocBlockCount(0), m_laidoutDocBlockCount(0)
		{}
	LaidoutChunk(size_t unLaidoutDocBlockCount,
					size_t laidoutDocBlockCount,
					const std::gap_vector<size_t> &blocks)
		: m_unLaidoutDocBlockCount(unLaidoutDocBlockCount)
		, m_laidoutDocBlockCount(laidoutDocBlockCount)
		, m_blocks(blocks)
		{}
	LaidoutChunk(const LaidoutChunk &x)
		: m_unLaidoutDocBlockCount(x.m_unLaidoutDocBlockCount)
		, m_laidoutDocBlockCount(x.m_laidoutDocBlockCount)
		, m_blocks(x.m_blocks)
		{}

public:
	size_t	docBlockCount() const
	{
		return m_unLaidoutDocBlockCount + m_laidoutDocBlockCount;
	}
	size_t	viewBlockCount() const
	{
		return m_unLaidoutDocBlockCount + m_blocks.size();
	}

public:
	LaidoutChunk	&operator=(const LaidoutChunk &x)
	{
		m_unLaidoutDocBlockCount = x.m_unLaidoutDocBlockCount;
		m_laidoutDocBlockCount = x.m_laidoutDocBlockCount;
		m_blocks = x.m_blocks;
		return *this;
	}
};

class LaidoutBlocksMgr
{
public:
	LaidoutBlocksMgr(TextDocument *document);
		//: m_document(document)
		//{}

public:
	size_t	docBlockCount() const;		//	LaidoutBlocksMgr ǗĂs
	size_t	viewBlockCount() const;		//	LaidoutBlocksMgr ǗĂs
	size_t	size() const;				//	r[̃g[^s
	size_t	blockCount() const { return size(); }
	size_t	viewBlockSize(index_t) const;
	size_t	blockSize(index_t ix) const { return viewBlockSize(ix); }
	size_t	blockSizeSize() const { return m_blockSize.size(); }

	size_t	blockNumberFromDocBlockNumber(index_t) const;
	size_t	docBlockNumberFromBlockNumber(index_t) const;

	int		width() const { return m_width; }
	size_t	laidoutDocBlockCount() const { return m_laidoutDocBlockCount; }
	size_t	laidoutViewBlockCount() const { return m_blockSize.size(); }

public:
	void	clear();
	void	setWidth(int width) { m_width = width; }
	bool	insert(index_t docBlockNumber,		//	hLgubNԍi0..*j
					size_t docBlockCount,		//	CAEgsihLgubNj
					const std::gap_vector<size_t> &);		//	CAEg

	LaidoutBlock	begin() const;
	LaidoutBlock	lastBlock() const;
	LaidoutBlock	end() const;
	LaidoutBlock	findBlock(index_t position) const;
	LaidoutBlock	findBlockByNumber(index_t) const;
	LaidoutBlock	findBlockByDocNumber(index_t) const;
	const LaidoutBlock	*cacheBlock() const { return m_cacheBlock; }

public:
	void	erase(index_t first, index_t last /*, size_t delDocBlockCount*/)
	{
		if( first < m_blockSize.size() ) {
			last = qMin(m_blockSize.size(), last);
			m_laidoutDocBlockCount -= docBlockNumberFromBlockNumber(last) -
										docBlockNumberFromBlockNumber(first);
			m_blockSize.erase(first, last);
		}
#if 0
		m_laidoutDocBlockCount -= delDocBlockCount;
		m_blockSize.erase(first, last);
#endif
		//size_t sz = m_blockSize.size();
	}
#if 0
	void	buildBlocks(TextView *,
						DocBlock block,		//	[CAEgJnʒu
						index_t vIndex = 0,		//	[CAEgJnʒu
						int ht = 0,				//	CAEg͈);
						index_t diLimit = 0);	//	CAEg͈);
#endif
	void	buildBlocksUntillDocBlockNumber(TextView *,
						DocBlock block,		//	[CAEgJnʒu
						index_t vIndex = 0,		//	[CAEgJnʒu
						int ht = 0,				//	CAEg͈);
						index_t docBlockNumber = 0);	//	CAEg͈);

protected:
	const TextDocument	*document() const { return m_document; }
	TextDocument	*document() { return m_document; }


private:
	TextDocument	*m_document;
	int		m_width;
	size_t	m_laidoutDocBlockCount;				//	CAEgς݃hLgubN
	mutable LaidoutBlock	*m_cacheBlock;
#if SIMPLE_LAIDOUT_BLOCKS
	std::gap_vector<size_t>	m_blockSize;		//	r[ubNA0 Ȃ͖CAEg
#else
	std::gap_vector<LaidoutChunk>	m_chunks;
#endif

	friend class LaidoutBlock;
};

class LaidoutBlock
{
public:
	LaidoutBlock(/*TextView *view,*/ LaidoutBlocksMgr *lbMgr)
		: /*m_view(view),*/ m_lbMgr(lbMgr)
		, m_viewBlockData(0, 0), m_docBlockData(0, 0)
#if !SIMPLE_LAIDOUT_BLOCKS
		, m_chunkIndex(0), m_indexInChunk(0)
#endif
		{}
	LaidoutBlock(LaidoutBlocksMgr *lbMgr, BlockData viewBlockData, BlockData docBlockData)
		: m_lbMgr(lbMgr)
		, m_viewBlockData(viewBlockData), m_docBlockData(docBlockData)
		{}

public:
	bool	isValid() const;
	bool	isLayouted() const;
	index_t	position() const { return m_viewBlockData.m_position; }
	index_t	index() const { return m_viewBlockData.m_index; }
	index_t	blockNumber() const { return m_viewBlockData.m_index; }
	index_t	docPosition() const { return m_docBlockData.m_position; }
	index_t	docIndex() const { return m_docBlockData.m_index; }
	index_t	docBlockNumber() const { return m_docBlockData.m_index; }
	BlockData	viewBlockData() const { return BlockData(blockNumber(), position()); }
	BlockData	docBlockData() const { return BlockData(docBlockNumber(), docPosition()); }

	size_t	size() const;
	QString	text() const;


	bool	operator==(const LaidoutBlock &x) const { return index() == x.index(); }

public:
	TextDocument	*document() { return m_lbMgr->m_document; }
	void			moveToEndOfDocument();
	LaidoutBlock	&operator++();
	LaidoutBlock	&operator--();

private:
	LaidoutBlocksMgr	*m_lbMgr;
	BlockData	m_viewBlockData;
	BlockData	m_docBlockData;
#if		SIMPLE_LAIDOUT_BLOCKS
#else
	index_t		m_chunkIndex;
	index_t		m_indexInChunk;
	//TextView	*m_view;
#endif
};

#endif		//_HEADER_TESTBLOCK_H
