/*
 * Decompiled with CFR 0.152.
 */
package jp.xet.eclipse.strictjava.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.HashMap;
import jp.xet.eclipse.strictjava.StrictJavaPlugin;
import jp.xet.eclipse.strictjava.wizards.NewStrictJavaProjectWizardPage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class StrictJavaProjectWizard
extends NewElementWizard
implements IExecutableExtension {
    private NewStrictJavaProjectWizardPage page;
    private IConfigurationElement fConfigElement;

    public StrictJavaProjectWizard() {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWJPRJ);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.JavaProjectWizard_title);
    }

    public void addPages() {
        this.page = new NewStrictJavaProjectWizardPage();
        this.addPage((IWizardPage)this.page);
        this.page.init(this.getSelection(), this.getActivePart());
    }

    public IJavaElement getCreatedElement() {
        return this.page.getJavaProject();
    }

    public boolean performCancel() {
        this.page.performCancel();
        return super.performCancel();
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        final IJavaProject javaProject = this.page.getJavaProject();
        final IWorkingSet[] workingSets = this.page.getWorkingSets();
        final HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("${projectName}", this.page.getJavaProject().getProject().getName());
        replace.put("${groupId}", this.page.getGroupId());
        replace.put("${currentYear}", String.valueOf(Calendar.getInstance().get(1)));
        replace.put("${copyrightHolder}", this.page.getCopyrightHolder());
        if (res) {
            new Job("create strict Java project"){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("creating strict Java project", 4);
                    StrictJavaPlugin.makeStrict(javaProject, replace, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    final IJavaElement newElement = StrictJavaProjectWizard.this.getCreatedElement();
                    if (workingSets.length > 0) {
                        PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)newElement, workingSets);
                    }
                    monitor.worked(1);
                    BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)StrictJavaProjectWizard.this.fConfigElement);
                    StrictJavaProjectWizard.this.selectAndReveal((IResource)javaProject.getProject());
                    monitor.worked(1);
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            IWorkbenchPart activePart = StrictJavaProjectWizard.this.getActivePart();
                            if (activePart instanceof IPackagesViewPart) {
                                PackageExplorerPart view = PackageExplorerPart.openInActivePerspective();
                                view.tryToReveal((Object)newElement);
                            }
                        }
                    });
                    monitor.worked(1);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        return res;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.page.performFinish(monitor);
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        String title = NewWizardMessages.JavaProjectWizard_op_error_title;
        String message = NewWizardMessages.JavaProjectWizard_op_error_create_message;
        ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
            return activePage.getActivePart();
        }
        return null;
    }
}

