package jp.xet.eclipse.activitytracker;

import java.lang.reflect.Field;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

/**
 * Hooks up the plugin listeners.
 */
public class Startup implements IStartup {
	
	/**
	 * Hooks up event listeners.
	 */
	public void earlyStartup() {
		final IWorkbench workbench = PlatformUI.getWorkbench();
		workbench.getDisplay().asyncExec(new Runnable() {
			
			public void run() {
				Display d = workbench.getDisplay();
				Listener l = Activator.getDefault().getListener();
				d.addFilter(SWT.Traverse, l);
				d.addFilter(SWT.KeyDown, l);
//				d.addFilter(SWT.KeyUp, l);
				d.addFilter(SWT.MouseDown, l);
				d.addFilter(SWT.MouseUp, l);
				
				// Display#filterTable#listeners の順番入れ替え…。過去最悪の黒魔術。
				// 順番入れ替え中のタイミングで別のスレッドからfilter追加とかされるとアウトですねｗ
				try {
					Field filterTableField = Display.class.getDeclaredField("filterTable");
					filterTableField.setAccessible(true);
					Object filterTable = filterTableField.get(d);
					Class<?> eventTableClass = Class.forName("org.eclipse.swt.widgets.EventTable");
					
					Field listenersField = eventTableClass.getDeclaredField("listeners");
					listenersField.setAccessible(true);
					Listener[] listeners = (Listener[]) listenersField.get(filterTable);
					Listener[] newListeners = new Listener[listeners.length];
					
					Field typesField = eventTableClass.getDeclaredField("types");
					typesField.setAccessible(true);
					int[] types = (int[]) typesField.get(filterTable);
					int[] newTypes = new int[types.length];
					
					int index = 0;
					for (int i = 0; i < listeners.length; i++) {
						if (listeners[i] instanceof UserActivityListener) {
							newListeners[index] = listeners[i];
							newTypes[index] = types[i];
							index++;
						}
					}
					for (int i = 0; i < listeners.length; i++) {
						if ((listeners[i] instanceof UserActivityListener) == false) {
							newListeners[index] = listeners[i];
							newTypes[index] = types[i];
							index++;
						}
					}
					
					listenersField.set(filterTable, newListeners);
					typesField.set(filterTable, newTypes);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}
}
