package jp.xet.eclipse.memopad.views;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.*;
import org.eclipse.swt.SWT;

public class MemopadView extends ViewPart {
	private Text textArea;

	/**
	 * The constructor.
	 */
	public MemopadView() {
	}

	/**
	 * This is a callback that will allow us to create the viewer and initialize
	 * it.
	 */
	public void createPartControl(Composite parent) {
		textArea = new Text(parent, SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);
		textArea.addKeyListener(new KeyListener() {

			public void keyPressed(KeyEvent e) {
				if((e.keyCode == 97) && (e.stateMask == 262144)) {	// CTRL+A
					textArea.selectAll();
				}
			}

			public void keyReleased(KeyEvent e) {
				// nothing to do
			}
			
		});
	}

	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		textArea.setFocus();
	}
}