package jp.gr.java_conf.ykhr.eclipse.plugin.chocoxslt;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.preference.IPreferenceStore;

public class InputCache {

    public static final String KEY_INPUT = ".input"; //$NON-NLS-1$
    public static final String KEY_OUTPUT = ".output"; //$NON-NLS-1$
    public static final String KEY_PROPERTY = ".property"; //$NON-NLS-1$
    
    private String baseKey;
    private IPreferenceStore store;
    
    public InputCache(IFile file) {
        baseKey = createBaseKey(file);
        store = Activator.getDefault().getPreferenceStore();
    }
    
    public boolean hasLastConfig() {
        return store.contains(baseKey);
    }
    
    public String getStoreValue(String key) {
        String name = baseKey + key;
        return store.getString(name);
    }
    
    public void storeLastValue(String key, String value) {
        String name = baseKey + key;
        store.setValue(name, value);
        store.setValue(baseKey, true);
    }
    
    private String createBaseKey(IFile file) {
        return file.getFullPath().toPortableString();
    }
    
}
