package jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.main;

import java.util.Map;

import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.JUnitReporterActivator;
import jp.gr.java_conf.ykhr.eclipse.plugin.junitreporter.ReportProperty;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;


public class FileCommand extends ReporterCommand {
    
    public FileCommand(Map testResults, ReportProperty prop) {
        super(testResults, prop);
    }
    
    protected String getOutputPath(IProgressMonitor monitor) {
        FileDialogRunnable dialog = new FileDialogRunnable();
        Display.getDefault().syncExec(dialog);
        return dialog.getPath();
    }

    protected HtmlConverter getHtmlConverter(String xmlPath, String output) {
        return new SingleHtmlConverter(xmlPath, output, prop);
    }
    
    private static class FileDialogRunnable implements Runnable {
        private String path;
        
        public String getPath() {
            return path;
        }
        
        public void run() {
            FileDialog dialog = new FileDialog(
                    JUnitReporterActivator.getShell(), SWT.SAVE);
            path = dialog.open();
        }
    }
    
}
