/* Copyright (c) 2019-2020 Alaskan Emily, Transnat Games
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#include "rejoy_bsd_core.h"
#include "rejoy_util.h"

#include <limits.h>

#ifdef __DragonFly__
#include <bus/usb/usb.h>
#else
#include <dev/usb/usb.h>
#endif

#ifdef __FREEBSD__
#include <dev/usb/usb_ioctl.h>
#endif

#include <sys/ioctl.h>

#if (defined __x86_86__) || (defined __amd64) || (defined __amd64__)
#define REJOY_BSD_CORE_AMD64
#elif (defined __i386) || (defined __i386__)
#define REJOY_BSD_CORE_X86
#endif

short Rejoy_BSD_ParseAxis(const void *buf, const hid_item_t *item){
    const int32_t data = hid_get_data(buf, item);
    const int32_t item_min = item->logical_minimum;
    const int32_t item_max = item->logical_maximum;
    
    return Rejoy_ScaleValue(item_min, item_max, data);
}

int Rejoy_BSD_ReportID(int fd){
#ifdef __FREEBSD__
    return hid_get_report_id(fd);
#else
    int r;
    if(ioctl(fd, USB_GET_REPORT_ID, &r) < 0)
        r = 0; /* This is safe on OpenBSD at least :/ */
    return r;
#endif
}

