// Copyright (c) 2021 Alaskan Emily, Transnat Games
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

#ifndef REJOY_EVDEV_HPP
#define REJOY_EVDEV_HPP
#pragma once

///////////////////////////////////////////////////////////////////////////////

#include "../rejoy.hpp"
#include "../unix/rejoy_unix.hpp"
#include "rejoy_evdev_bind.h"

///////////////////////////////////////////////////////////////////////////////

namespace Rejoy {

///////////////////////////////////////////////////////////////////////////////
// Tagged as struct so that it can be used in SLIST's
class EvdevGamepad : public Rejoy::UnixGamepad {
    struct Rejoy_Evdev_Gamepad *const m_data;
public:
    inline EvdevGamepad(int fd, struct Rejoy_Evdev_Gamepad *data)
      : UnixGamepad(fd,
            Rejoy_Evdev_GetNumAxes(data),
            Rejoy_Evdev_GetNumButtons(data),
            Rejoy_Evdev_GetNumHats(data))
      , m_data(data) {}
    
    explicit EvdevGamepad(const EvdevGamepad &other);
    
    ~EvdevGamepad();
    
    virtual void update();
    virtual const char *name() const {
        return Rejoy_Evdev_GetName(m_data);
    }
    virtual short getAxis(unsigned i) const {
        return Rejoy_Evdev_GetAxis(m_data, i);
    }
    virtual bool getButton(unsigned i) const {
        return Rejoy_Evdev_GetButton(m_data, i);
    }
    virtual unsigned getHat(unsigned i) const {
        return Rejoy_Evdev_GetHat(m_data, i);
    }
};

///////////////////////////////////////////////////////////////////////////////

class EvdevDriver : public Rejoy::Driver {
    // A Rust slice of EvdevGamepad.
    void *m_gamepad_list;

    void enumerateGamepad(int fd);
    static void EnumateGamepad(void *that, const char *name, int fd){
        (void)name;
        static_cast<EvdevDriver*>(that)->enumerateGamepad(fd);
    }
public:
    EvdevDriver()
      : Driver("evdev")
      , m_gamepad_list(NULL) {}
    
    ~EvdevDriver();
    
    virtual void update();
    virtual Gamepad *getGamepad(unsigned i);
};

///////////////////////////////////////////////////////////////////////////////

} // namespace Rejoy

///////////////////////////////////////////////////////////////////////////////

#endif // REJOY_EVDEV_HPP

