#[macro_use]
extern crate ioctl_sys;

use std::ptr;

// Generated constants from the C headers.
include!{concat!(env!("OUT_DIR"), "/rejoy_evdev_defs.rs")}

#[macro_use]
mod bitmap;

#[macro_use]
mod ioctl;
mod gamepad;

// Handwritten bindings.
type CVec = Vec<*mut core::ffi::c_void>;

/// C/C++ Binding to Vec::push
///
/// Specially handles a NULL input to create a new Vec.
#[allow(non_snake_case)]
#[no_mangle]
pub extern "C" fn Rejoy_Evdev_VecAppend(ptr: *mut core::ffi::c_void, val: *mut core::ffi::c_void) -> *mut core::ffi::c_void {
    (if ptr != ptr::null_mut() {
        let vec_ptr = ptr as *mut CVec;
        unsafe { (*vec_ptr).push(val); }
        vec_ptr
    }
    else{
        let vec: CVec = vec![val];
        let vec_box = Box::new(vec);
        Box::leak(vec_box) as *mut CVec
    }) as *mut core::ffi::c_void
}

/// C/C++ Binding to Vec::len
///
/// Specially handles a NULL input to be zero-length.
#[allow(non_snake_case)]
#[no_mangle]
pub extern "C" fn Rejoy_Evdev_VecGetLen(ptr: *const core::ffi::c_void) -> u32 {
    if ptr == ptr::null_mut() {
        0
    }
    else{
        let vec_ptr = ptr as *const CVec;
        unsafe { (*vec_ptr).len() as u32 }
    }
}

/// C/C++ Binding to Vec[]
///
/// Specially handles a NULL input to be filled with NULL's.
#[allow(non_snake_case)]
#[no_mangle]
pub extern "C" fn Rejoy_Evdev_VecGetValue(ptr: *const core::ffi::c_void, i: u32) -> *mut core::ffi::c_void {
    if ptr == ptr::null_mut() {
        ptr::null_mut()
    }
    else{
        let vec_ptr = ptr as *const CVec;
        unsafe { (*vec_ptr)[i as usize] }
    }
}

/// C/C++ Binding to dropping a Vec
#[allow(non_snake_case)]
#[no_mangle]
pub extern "C" fn Rejoy_Evdev_FinalizeVec(ptr: *mut core::ffi::c_void) {
    if ptr != ptr::null_mut() {
        let vec_ptr = ptr as *mut CVec;
        let _ = unsafe { Box::from_raw(vec_ptr) };
    }
}
