// Copyright (c) 2019 Alaskan Emily, Transnat Games
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

#include "rejoy_c.h"
#include "rejoy.hpp"

///////////////////////////////////////////////////////////////////////////////

static inline Rejoy::Gamepad *rejoy_gamepad(struct Rejoy_Gamepad *gamepad){
    return (Rejoy::Gamepad*)((void*)gamepad);
}

static inline const Rejoy::Gamepad *rejoy_gamepad(const struct Rejoy_Gamepad *gamepad){
    return (const Rejoy::Gamepad*)((const void*)gamepad);
}

///////////////////////////////////////////////////////////////////////////////

static inline Rejoy::Driver *rejoy_driver(struct Rejoy_Driver *driver){
    return (Rejoy::Driver*)((void*)driver);
}

static inline const Rejoy::Driver *rejoy_driver(const struct Rejoy_Driver *driver){
    return (const Rejoy::Driver*)((const void*)driver);
}

///////////////////////////////////////////////////////////////////////////////

REJOY_CALL(void) Rejoy_PollForGamepads(void){
    Rejoy::PollForGamepads();
}

///////////////////////////////////////////////////////////////////////////////

REJOY_CALL(void) Rejoy_GamepadUpdate(struct Rejoy_Gamepad *gamepad){
    rejoy_gamepad(gamepad)->update();
}

///////////////////////////////////////////////////////////////////////////////

REJOY_CALL(rejoy_str_t) Rejoy_GamepadName(const struct Rejoy_Gamepad *gamepad){
    return rejoy_gamepad(gamepad)->name();
}

///////////////////////////////////////////////////////////////////////////////

REJOY_CALL(unsigned) Rejoy_GamepadGetNumAxes(const struct Rejoy_Gamepad *gamepad){
    return rejoy_gamepad(gamepad)->getNumAxes();
}

///////////////////////////////////////////////////////////////////////////////

REJOY_CALL(short) Rejoy_GamepadGetAxis(const struct Rejoy_Gamepad *gamepad, unsigned i){
    return rejoy_gamepad(gamepad)->getAxis(i);
}

///////////////////////////////////////////////////////////////////////////////

REJOY_CALL(unsigned) Rejoy_GamepadGetNumButtons(const struct Rejoy_Gamepad *gamepad){
    return rejoy_gamepad(gamepad)->getNumButtons();
}

///////////////////////////////////////////////////////////////////////////////

REJOY_CALL(int) Rejoy_GamepadGetButton(const struct Rejoy_Gamepad *gamepad, unsigned i){
    return rejoy_gamepad(gamepad)->getButton(i);
}

///////////////////////////////////////////////////////////////////////////////

REJOY_CALL(unsigned) Rejoy_GetNumDrivers(void){
    return Rejoy::GetNumDrivers();
}

///////////////////////////////////////////////////////////////////////////////

REJOY_CALL(rejoy_driver_t) Rejoy_GetDriver(unsigned i){
    return (rejoy_driver_t)Rejoy::GetDriver(i);
}

///////////////////////////////////////////////////////////////////////////////

REJOY_CALL(void) Rejoy_DriverUpdate(struct Rejoy_Driver *driver){
    rejoy_driver(driver)->update();
}

///////////////////////////////////////////////////////////////////////////////

REJOY_CALL(rejoy_str_t) Rejoy_DriverName(const struct Rejoy_Driver *driver){
    return rejoy_driver(driver)->m_name;
}

///////////////////////////////////////////////////////////////////////////////

REJOY_CALL(unsigned) Rejoy_DriverGetNumGamepads(const struct Rejoy_Driver *driver){
    return rejoy_driver(driver)->getNumGamepads();
}

///////////////////////////////////////////////////////////////////////////////

REJOY_CALL(rejoy_gamepad_t) Rejoy_DriverGetGamepad(struct Rejoy_Driver *driver, unsigned i){
    return (rejoy_gamepad_t)rejoy_driver(driver)->getGamepad(i);
}

///////////////////////////////////////////////////////////////////////////////
