#include "rejoy.hpp"

#include <stdio.h>

#include <vector>

#if (defined _WIN32) || (defined __CYGWIN__)

#include <Windows.h>
#define REJOY_SLEEP Sleep

#else

#include <unistd.h>
#define REJOY_SLEEP(X) do{ usleep(X * 1000); } while(0)

#endif

int main(int argc, char **argv){
    (void)argc;
    (void)argv;
    
    Rejoy::Init();
    
    const size_t num_drivers = Rejoy::GetNumDrivers();
    std::vector<Rejoy::Driver*> drivers(num_drivers);
    
    printf("Found %i drivers\n", (int)num_drivers);
    for(unsigned i = 0; i < num_drivers; i++){
        
        Rejoy::Driver *&driver = drivers[i];
        driver = Rejoy::GetDriver(i);
        
        driver->update();
        const unsigned num_gamepads = driver->getNumGamepads();
        printf("Driver %u: %s, %u gamepads\n",
            i+1u,
            driver->m_name,
            num_gamepads);
        
        for(unsigned e = 0; e < num_gamepads; e++){
            Rejoy::Gamepad *const gamepad = driver->getGamepad(e);
            const unsigned num_buttons = gamepad->getNumButtons();
            const unsigned num_axes = gamepad->getNumAxes();
            printf("\tGamepad %u: '%s', %u buttons %u axes\n",
                e,
                gamepad->name(),
                num_buttons,
                num_axes);
        }
    }
    
    while(true){
        REJOY_SLEEP(64);
        for(unsigned i = 0; i < num_drivers; i++){
            Rejoy::Driver *&driver = drivers[i];
            const unsigned num_gamepads = driver->getNumGamepads();
            
            for(unsigned e = 0; e < num_gamepads; e++){
                Rejoy::Gamepad *const gamepad = driver->getGamepad(e);
                gamepad->update();
                puts(gamepad->name());
                const unsigned num_buttons = gamepad->getNumButtons();
                const unsigned num_axes = gamepad->getNumAxes();
                
                for(unsigned b = 0; b < num_buttons; b++){
                    fputs(gamepad->getButton(b) ? " 1 " : " 0 ", stdout);
                }
                
                putchar('\n');
                
                for(unsigned a = 0; a < num_axes; a++){
                    printf("%i\t", gamepad->getAxis(a));
                }
                
                putchar('\n');
            }
        }
        
    }
}
