/* Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/publicdomain/zero/1.0/
 */

#ifndef REJOY_EXPORT
#pragma once

/*****************************************************************************/
/* The macro REJOY_INTERNAL_DLL should only be defined on Windows. */
#ifdef REJOY_INTERNAL_DLL

#define REJOY_EXPORT __declspec(dllexport)

#else

#define REJOY_EXPORT

#endif

/*****************************************************************************/

#if (defined _WIN32) && !(defined _WIN64)
/* Win32, define a calling convention (stdcall) */
#if (defined __CYGWIN__) || (defined __GUNC__) || (defined __TINYC__)
/* GCC-style */
#define REJOY_CALL(T) __attribute__((stdcall)) T
#define REJOY_CDECL(T) __attribute__((cdecl)) T

#else
/* MSVC/Watcom/Intel style */
#define REJOY_CALL(T) T __stdcall
#define REJOY_CDECL(T) T __cdecl

#endif

#else

#define REJOY_CALL(T) T
#define REJOY_CDECL(T) T

#endif

/*****************************************************************************/

#endif
