/* Copyright (c) 2020 Alaskan Emily, Transnat Games
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/*****************************************************************************/
/* Hat definitions shared between the C and C++ APIs. */

#ifndef REJOY_HAT_H
#define REJOY_HAT_H
#pragma once

/*****************************************************************************/
/* Enable bits are set if a direction in the respective axis was pressed.
 * when an enable bit is set, the following bit indicates which direction
 * was pressed.
 */
#define REJOY_HAT_VERTICAL_ENABLE_BIT (1<<0)
#define REJOY_HAT_VERTICAL_BIT (1<<1)

#define REJOY_HAT_HORIZONTAL_ENABLE_BIT (1<<2)
#define REJOY_HAT_HORIZONTAL_BIT (1<<3)

/*****************************************************************************/
/* Cardinal directions */
#define REJOY_HAT_UP    (REJOY_HAT_VERTICAL_ENABLE_BIT)
#define REJOY_HAT_DOWN \
    (REJOY_HAT_VERTICAL_ENABLE_BIT|REJOY_HAT_VERTICAL_BIT)

#define REJOY_HAT_LEFT  (REJOY_HAT_HORIZONTAL_ENABLE_BIT)
#define REJOY_HAT_RIGHT \
    (REJOY_HAT_HORIZONTAL_ENABLE_BIT|REJOY_HAT_HORIZONTAL_BIT)

/*****************************************************************************/
/* Diagonals */
#define REJOY_HAT_UP_LEFT       (REJOY_HAT_UP|REJOY_HAT_LEFT)
#define REJOY_HAT_UP_RIGHT      (REJOY_HAT_UP|REJOY_HAT_RIGHT)
#define REJOY_HAT_DOWN_LEFT     (REJOY_HAT_DOWN|REJOY_HAT_LEFT)
#define REJOY_HAT_DOWN_RIGHT    (REJOY_HAT_DOWN|REJOY_HAT_RIGHT)

/*****************************************************************************/
/* Diagonal Aliases */
#define REJOY_HAT_LEFT_UP       REJOY_HAT_UP_LEFT
#define REJOY_HAT_RIGHT_UP      REJOY_HAT_UP_RIGHT
#define REJOY_HAT_LEFT_DOWN     REJOY_HAT_DOWN_LEFT
#define REJOY_HAT_RIGHT_DOWN    REJOY_HAT_DOWN_RIGHT

/*****************************************************************************/

#endif /* REJOY_HAT_H */
