// Copyright (c) 2019 Alaskan Emily, Transnat Games
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

#ifndef REJOY_PRIVATE_HPP
#define REJOY_PRIVATE_HPP
#pragma once

///////////////////////////////////////////////////////////////////////////////

#include "rejoy.hpp"

///////////////////////////////////////////////////////////////////////////////
// TODO: Move these to a .h file?
#if (defined __GNUC__) || (defined __clang__)
#define REJOY_LIKELY(X) (__builtin_expect(!!(X), 1))
#define REJOY_UNLIKELY(X) (__builtin_expect(!!(X), 0))
#else
#define REJOY_LIKELY(X) (!!(X))
#define REJOY_UNLIKELY(X) (!!(X))
#endif

///////////////////////////////////////////////////////////////////////////////
// Some GCC 4 had this, but it's not a big deal if we don't get it.
#if (defined __GNUC__) && (__GNUC__ > 4)
#define REJOY_PURE __attribute__((const))
#elif (defined _MSC_VER) && (_MSC_VER >= 1500)
#define REJOY_PURE __declspec(noalias)
#else
#define REJOY_PURE
#endif

///////////////////////////////////////////////////////////////////////////////
// Glue for the simplest possible initialization mode. This is enough for all
// of our current drivers.
#define REJOY_STATIC_INIT(X) \
static X ## Driver *X ## _driver = NULL; \
static ::Rejoy::DriverList *X ## _driver_list = NULL; \
void Init ## X(){ \
    X ## _driver = new X ## Driver(); \
    X ## _driver_list = new Rejoy::DriverList(*X ## _driver); \
} \
void Shutdown ## X() { \
    delete X ## _driver; \
    X ## _driver = NULL; \
    delete X ## _driver_list; \
    X ## _driver_list = NULL; \
}

///////////////////////////////////////////////////////////////////////////////

namespace Rejoy {

///////////////////////////////////////////////////////////////////////////////
// Used to replace gamepads which are disconnected.
class NullGamepad : public Gamepad {
public:
    inline NullGamepad(unsigned numAxes, unsigned numButtons)
      : Gamepad(numAxes, numButtons) {}
    
    virtual short getAxis(unsigned i) const;
    
    virtual bool getButton(unsigned i) const;
};

///////////////////////////////////////////////////////////////////////////////
// Should be statically allocated, used to register drivers with the library.
struct DriverList {
    // The constructor will register this driver with the library.
    DriverList(Driver&);

    Driver &m_driver;
    struct DriverList *const m_next;
};

///////////////////////////////////////////////////////////////////////////////

} // namespace Rejoy

///////////////////////////////////////////////////////////////////////////////

#endif // REJOY_PRIVATE_HPP
