// Copyright (c) 2019-2020 Alaskan Emily, Transnat Games
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

#include "rejoy_unix.hpp"

#include <unistd.h>
#include <fcntl.h>

///////////////////////////////////////////////////////////////////////////////

namespace Rejoy {

///////////////////////////////////////////////////////////////////////////////

UnixGamepad::UnixGamepad(const char *path)
  : m_fd(open(path, O_RDONLY)) {
    
}

///////////////////////////////////////////////////////////////////////////////

UnixGamepad::UnixGamepad(const char *path,
    unsigned num_axes,
    unsigned num_buttons,
    unsigned num_hats)
  : Rejoy::Gamepad(num_axes, num_buttons, num_hats)
  , m_fd(open(path, O_RDONLY)) {
    
}

///////////////////////////////////////////////////////////////////////////////

UnixGamepad::UnixGamepad(const UnixGamepad& other)
  : Gamepad(other)
  , m_fd(dup(other.m_fd)) {
    
}

///////////////////////////////////////////////////////////////////////////////

void UnixGamepad::invalidate(){
    if(valid()){
        close(m_fd);
        m_fd = -1;
    }
}

///////////////////////////////////////////////////////////////////////////////
    
UnixGamepad::~UnixGamepad(){
    if(valid()){
        close(m_fd);
    }
}

///////////////////////////////////////////////////////////////////////////////

} // namespace Rejoy

///////////////////////////////////////////////////////////////////////////////

