// Copyright (c) 2019-2020 Alaskan Emily, Transnat Games
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

#ifndef REJOY_UNIX_HPP
#define REJOY_UNIX_HPP
#pragma once

///////////////////////////////////////////////////////////////////////////////

#include "../rejoy.hpp"

///////////////////////////////////////////////////////////////////////////////

namespace Rejoy {

///////////////////////////////////////////////////////////////////////////////

class UnixGamepad : public Rejoy::Gamepad {
    int m_fd;
protected:
    
    explicit inline UnixGamepad(int fd)
      : m_fd(fd){
        
    }
    
    inline UnixGamepad(int fd,
        unsigned num_axes,
        unsigned num_buttons,
        unsigned num_hats)
      : Rejoy::Gamepad(num_axes, num_buttons, num_hats)
      , m_fd(fd){
        
    }
    
    explicit UnixGamepad(const char *path);
    
    UnixGamepad(const char *path,
        unsigned num_axes,
        unsigned num_buttons,
        unsigned num_hats);

    explicit UnixGamepad(const UnixGamepad& other);
    
    void invalidate();
    inline bool valid() const { return m_fd >= 0; }
    inline int fd() const { return m_fd; }

public:
    
    ~UnixGamepad();
};

///////////////////////////////////////////////////////////////////////////////

} // namespace Rejoy

///////////////////////////////////////////////////////////////////////////////

#endif // REJOY_UNIX_HPP

