; Any copyright is dedicated to the Public Domain.
; http://creativecommons.org/publicdomain/zero/1.0/

bits 64

segment .text

global Rejoy_ScaleValue

div_by_zero:
    xor rax, rax
    ret

; Rejoy_ScaleValue(int from, int to, int t)
Rejoy_ScaleValue:
    mov r10d, 0x0000FFFF

    ; Windows has different registers for params. We can also use one fewer
    ; movs on non-Windows because the mul/div won't dirty one of our parameter
    ; registers then.
%ifdef REJOY_WINDOWS
    mov rax, r8
    sub rax, rcx
    
    ; Set r11 to the item range. We can't just do this to rdx since the imul
    ; will dirty it.
    mov r11, rdx
    sub r11, rcx
    jz div_by_zero
    imul r10d
    idiv r11d

%else
    mov rax, rdx
    sub rax, rdi
    
    ; Set rsi to the item range
    sub rsi, rdi
    jz div_by_zero
    imul r10d
    idiv esi

%endif
    
    add ax, 0x8000
    ret
