/* Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/publicdomain/zero/1.0/ */

#include "rejoy_util.h"

#include <stdint.h>
#include <limits.h>

#define REJOY_SHRT_RANGE (SHRT_MAX - SHRT_MIN)

REJOY_CDECL(int) Rejoy_ScaleValue(int from, int to, int t){
    const int item_range = to - from;
    int64_t scaled_data = t;
    if(item_range == 0)
        return to;
    scaled_data -= from;
    scaled_data *= REJOY_SHRT_RANGE;
    scaled_data /= item_range;
    scaled_data += SHRT_MIN;
    return (int)scaled_data;
}
