/* Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/publicdomain/zero/1.0/ */
 
#ifndef REJOY_UTIL_H
#define REJOY_UTIL_H
#pragma once

/*****************************************************************************/

#include "../rejoy_export.h"

/*****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @brief Scales a signed 32-bit input to be in the range of an unsigned short.
 *
 * Always returns in the range of SHRT_MIN to SHRT_MAX, but we force a full int
 * size to ensure consistent ABI
 */
REJOY_CDECL(int) Rejoy_ScaleValue(int from, int to, int t);

#ifdef __cplusplus
} // extern "C"
#endif

#endif /* REJOY_UTIL_H */
