// Copyright (c) 2019-2020 Alaskan Emily, Transnat Games
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

#include "rejoy_xinput.hpp"

///////////////////////////////////////////////////////////////////////////////

namespace Rejoy {

///////////////////////////////////////////////////////////////////////////////

void update();

///////////////////////////////////////////////////////////////////////////////

void XInputDriver::update() {
    unsigned num_gamepads = 0;
    for(unsigned i = 0; i < 4; i++){
        const bool connected = !!Rejoy_XInput_IsConnected(i);
        if(connected)
            num_gamepads++;
        
        // Check if we need to either delete a controller that got disconnected
        // or add a controller that was connected.
        if(m_gamepads[i] != NULL && !connected){
            delete m_gamepads[i];
            m_gamepads[i] = NULL;
        }
        else if(m_gamepads[i] == NULL && connected){
            const bool has_nav = !!Rejoy_XInput_HasNavigation(i);
            m_gamepads[i] = new XInputGamepad(i, has_nav);
        }
    }
    
    m_num_gamepads = num_gamepads;
}


///////////////////////////////////////////////////////////////////////////////

Gamepad *XInputDriver::getGamepad(unsigned n){
    
    for(unsigned i = 0; i < 4; i++){
        if(m_gamepads[i] != NULL){
            if(n == 0)
                return m_gamepads[n];
            else
                n--;
        }
    }
    
    return NULL;
}

///////////////////////////////////////////////////////////////////////////////

REJOY_STATIC_INIT(XInput);

///////////////////////////////////////////////////////////////////////////////

} // namespace Rejoy

///////////////////////////////////////////////////////////////////////////////


