/* Copyright (c) 2020 Alaskan Emily, Transnat Games
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef REJOY_XINPUT_CORE_H
#define REJOY_XINPUT_CORE_H
#pragma once

/*****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************/

#define REJOY_XINPUT_CONVERT_TRIGGER(T) ((((short)(T)) - 0x80) << 8)

#define REJOY_XINPUT_NUM_BUTTONS 10
#define REJOY_XINPUT_NUM_BUTTONS_NO_NAV (REJOY_XINPUT_NUM_BUTTONS-2)

#define REJOY_XINPUT_NUM_AXES 6

/*****************************************************************************/

struct _XINPUT_GAMEPAD;

/*****************************************************************************/

unsigned Rejoy_XInput_IsConnected(unsigned n);

/*****************************************************************************/

unsigned Rejoy_XInput_HasNavigation(unsigned n);

/*****************************************************************************/

short Rejoy_XInput_GetAxis(const struct _XINPUT_GAMEPAD *gamepad, unsigned n);

/*****************************************************************************/

unsigned Rejoy_XInput_GetHat(const struct _XINPUT_GAMEPAD *gamepad);

/*****************************************************************************/

extern const char rejoy_xinput_controller_names[4][16];

/*****************************************************************************/
/* The start/back buttons are at the end, so that when
 * XINPUT_CAPS_NO_NAVIGATION is found the number of buttons can just be reduced
 * by 2 and the mapping is still valid.
 */
extern const unsigned rejoy_xinput_button_masks[REJOY_XINPUT_NUM_BUTTONS];

/*****************************************************************************/

#ifdef __cplusplus
} // extern "C"
#endif

/*****************************************************************************/

#endif /* REJOY_XINPUT_CORE_H */
