#include <QDebug>
//#include <QMessageBox>

#include "PlayMusicThread.h"

PlayMusicThread::PlayMusicThread(WId winId)
{
    stopped = false;

#ifdef __WIN32__
    if (!BASS_Init(-1, 44100, 0, winId, NULL)) {
#else
    if (!BASS_Init(-1, 44100, 0, (void*)winId, NULL)) {
#endif
//        QMessageBox::warning(this, "Error", "BASS_Init, Fail");
        // qDebug() << "BASS_Init Error";
    }

    FilePath = "";
    state = IDLE;
    playstopped = false;
}

PlayMusicThread::~PlayMusicThread()
{
    MusicStop();

    // bass library Finalize
    BASS_Free();
}

void PlayMusicThread::stop()
{
    stopped = true;
}

void PlayMusicThread::PlayMusic(const QString &filepath) {
    if (state == IDLE) {
        FilePath = filepath;
    }
}

void PlayMusicThread::StopMusic() {
    if (state == PLAYING) {
        playstopped = true;
    }
}
int PlayMusicThread::GetPlayStatus() {
    return state;
}

void PlayMusicThread::run()
{
    while (!stopped) {
        if (state == IDLE) {
            if (FilePath.isEmpty()) {
                ;
            } else {
                // Count = 0;
                // Music Start
                QString PlayFileName;
                if (MusicStart(FilePath)) {
                    PlayFileName = ""; // Error
                } else {
                    PlayFileName = FilePath;
                }
                playstopped = false;
                state = PLAYING;
                emit MusicStarted(PlayFileName);
            }
        } else if (state == PLAYING){
            if (!IsMusicPlaying() || playstopped) {
                // Music Stop
                MusicStop();
                FilePath = "";
                state = IDLE;
                emit MusicEnded();
            } else {
                // Count++;
                //qDebug() << QString("%1").arg(Count);
            }
        }
        msleep(100);
    }
}

int PlayMusicThread::MusicStart(const QString &musicfilepath)
{
    // qDebug() << "Play Music : " << musicfilepath;
    if (hStrm = BASS_StreamCreateFile(FALSE, musicfilepath.toLocal8Bit(), 0, 0, 0)) {
        ;
    } else {
        // qDebug() << "BASS_StreamCreateFile Error";
//        QMessageBox::warning(this, "Error", "BASS_StreamCreateFile, Fail");;
        return 1;
    }

//    if (len_seconds != NULL) {
//        *len_seconds =GetChLength_Seconds();
//    }

    if (!BASS_ChannelPlay(hStrm, 0)) {
//        QMessageBox::warning(this, "Error", "BASS_ChannelPlay, Fail");;
        return 1;
    }
    return 0;
}

void PlayMusicThread::MusicStop()
{
    // qDebug() << "Stop Music";
    if (hStrm) {
        BASS_ChannelStop(hStrm);
        BASS_StreamFree(hStrm);
        hStrm = NULL;
    }
}

int PlayMusicThread::IsMusicPlaying()
{
    int status = BASS_ChannelIsActive(hStrm);
    return (status == BASS_ACTIVE_PLAYING);
}

float PlayMusicThread::GetSoundVolume()
{
    return BASS_GetVolume();
}

void PlayMusicThread::SetSoundVolume(float volume)
{
    BASS_SetVolume(volume);
}

// -eof-
