﻿Imports Microsoft.VisualStudio.TestTools.UnitTesting

Imports ReversiGame



'''<summary>
'''BoardTest のテスト クラスです。すべての
'''BoardTest 単体テストをここに含めます
'''</summary>
<TestClass()> _
Public Class BoardTest


    Private testContextInstance As TestContext

    '''<summary>
    '''現在のテストの実行についての情報および機能を
    '''提供するテスト コンテキストを取得または設定します。
    '''</summary>
    Public Property TestContext() As TestContext
        Get
            Return testContextInstance
        End Get
        Set(ByVal value As TestContext)
            testContextInstance = Value
        End Set
    End Property

#Region "追加のテスト属性"
    '
    'テストを作成するときに、次の追加属性を使用することができます:
    '
    'クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
    '<ClassInitialize()>  _
    'Public Shared Sub MyClassInitialize(ByVal testContext As TestContext)
    'End Sub
    '
    'クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
    '<ClassCleanup()>  _
    'Public Shared Sub MyClassCleanup()
    'End Sub
    '
    '各テストを実行する前にコードを実行するには、TestInitialize を使用
    '<TestInitialize()>  _
    'Public Sub MyTestInitialize()
    'End Sub
    '
    '各テストを実行した後にコードを実行するには、TestCleanup を使用
    '<TestCleanup()>  _
    'Public Sub MyTestCleanup()
    'End Sub
    '
#End Region


    '''<summary>
    '''Board コンストラクター のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub BoardConstructorTest()
        Dim target As Board = New Board()
        For x As Integer = 0 To Board.SIZE_X - 1
            For y As Integer = 0 To Board.SIZE_Y - 1
                If x = 3 AndAlso y = 3 OrElse
                    x = 4 AndAlso y = 4 Then
                    Assert.AreEqual(Board.WHITE, target.CellStone(x, y))
                ElseIf x = 3 AndAlso y = 4 OrElse
                    x = 4 AndAlso y = 3 Then
                    Assert.AreEqual(Board.BLACK, target.CellStone(x, y))
                Else
                    Assert.AreEqual(Board.EMPTY, target.CellStone(x, y))
                End If
            Next
        Next
   

    End Sub

    '''<summary>
    '''Board コンストラクター のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub BoardConstructorTest1()
        Dim source As Board = New Board()
        source.CellStone(0, 0) = Board.BLACK
        source.CellStone(7, 7) = Board.BLACK
        source.CellStone(0, 7) = Board.BLACK
        source.CellStone(7, 0) = Board.BLACK
        source.TurnChange()
        Dim target As Board = New Board(source)
        For x As Integer = 0 To Board.SIZE_X - 1
            For y As Integer = 0 To Board.SIZE_Y - 1
                Assert.AreEqual(source.CellStone(x, y), target.CellStone(x, y))
            Next
        Next
        Assert.AreEqual(source.Turn, target.Turn)
    End Sub

    '''<summary>
    '''CanPut のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub CanPutTest()
        Dim target As New Board
        For x As Integer = 0 To Board.SIZE_X - 1
            For y As Integer = 0 To Board.SIZE_Y - 1
                If x = 3 AndAlso y = 2 OrElse
                    x = 2 AndAlso y = 3 OrElse
                   x = 5 AndAlso y = 4 OrElse
                   x = 4 AndAlso y = 5 Then
                    Assert.AreEqual(True, target.CanPut(x, y))
                Else
                    Assert.AreEqual(False, target.CanPut(x, y))
                End If
            Next
        Next

    End Sub

    '''<summary>
    '''CanPutAny のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub CanPutAnyTest()
        Dim target As Board = New Board()
        Assert.AreEqual(True, target.CanPutAny)
        For x As Integer = 0 To Board.SIZE_X - 1
            For y As Integer = 0 To Board.SIZE_Y - 1
                target.CellStone(x, y) = Board.BLACK
            Next
        Next
        Assert.AreEqual(False, target.CanPutAny)
    End Sub

    '''<summary>
    '''CanReverse のテスト
    '''</summary>
    <TestMethod(), _
     DeploymentItem("ReversiGame.exe")> _
    Public Sub CanReverseTest()
        Dim target As Board_Accessor = New Board_Accessor()
        Assert.AreEqual(True, target.CanReverse(3, 2, 0, 1))
        Assert.AreEqual(False, target.CanReverse(3, 2, 0, -1))
        Assert.AreEqual(False, target.CanReverse(3, 2, 1, -1))
        Assert.AreEqual(False, target.CanReverse(3, 2, 1, 0))
        Assert.AreEqual(False, target.CanReverse(3, 2, 1, 1))
        Assert.AreEqual(False, target.CanReverse(3, 2, -1, -1))
        Assert.AreEqual(False, target.CanReverse(3, 2, -1, 0))
        Assert.AreEqual(False, target.CanReverse(3, 2, -1, 1))
    End Sub

    '''<summary>
    '''Put のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub PutTest()
        Dim target As Board = New Board()
        target.Put(3, 2)
        For x As Integer = 0 To Board.SIZE_X - 1
            For y As Integer = 0 To Board.SIZE_Y - 1
                If x = 3 AndAlso y = 2 OrElse
                    x = 3 AndAlso y = 3 OrElse
                    x = 3 AndAlso y = 4 OrElse
                    x = 4 AndAlso y = 3 Then
                    Assert.AreEqual(Board.BLACK, target.CellStone(x, y))
                ElseIf x = 4 AndAlso y = 4 Then
                    Assert.AreEqual(Board.WHITE, target.CellStone(x, y))
                Else
                    Assert.AreEqual(Board.EMPTY, target.CellStone(x, y))
                End If
            Next
        Next


    End Sub

    '''<summary>
    '''Reverse のテスト
    '''</summary>
    <TestMethod(), _
     DeploymentItem("ReversiGame.exe")> _
    Public Sub ReverseTest()
        Dim target As Board_Accessor = New Board_Accessor()
        target.Reverse(3, 2, 0, 1)
        For x As Integer = 0 To Board.SIZE_X - 1
            For y As Integer = 0 To Board.SIZE_Y - 1
                If x = 3 AndAlso y = 3 OrElse
                    x = 3 AndAlso y = 4 OrElse
                    x = 4 AndAlso y = 3 Then
                    Assert.AreEqual(Board.BLACK, target.CellStone(x, y))
                ElseIf x = 4 AndAlso y = 4 Then
                    Assert.AreEqual(Board.WHITE, target.CellStone(x, y))
                Else
                    Assert.AreEqual(Board.EMPTY, target.CellStone(x, y))
                End If
            Next
        Next

    End Sub

    '''<summary>
    '''StoneCount のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub StoneCountTest()
        Dim target As Board = New Board()
        Assert.AreEqual(2, target.StoneCount(Board.BLACK))
        Assert.AreEqual(2, target.StoneCount(Board.WHITE))
        Assert.AreEqual(60, target.StoneCount(Board.EMPTY))
        target.Put(3, 2)
        Assert.AreEqual(4, target.StoneCount(Board.BLACK))
        Assert.AreEqual(1, target.StoneCount(Board.WHITE))
        Assert.AreEqual(59, target.StoneCount(Board.EMPTY))
    End Sub

    '''<summary>
    '''TurnChange のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub TurnChangeTest()
        Dim target As Board = New Board()
        Assert.AreEqual(Board.BLACK, target.Turn)
        target.TurnChange()
        Assert.AreEqual(Board.WHITE, target.Turn)
        target.TurnChange()
        Assert.AreEqual(Board.BLACK, target.Turn)
    End Sub

    '''<summary>
    '''ValidPosition のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub ValidPositionTest()
        For x As Integer = 0 To Board.SIZE_X - 1
            For y As Integer = 0 To Board.SIZE_Y - 1
                Assert.AreEqual(True, Board.ValidPosition(x, y))
            Next
        Next
        Assert.AreEqual(False, Board.ValidPosition(-1, -1))
        Assert.AreEqual(False, Board.ValidPosition(0, -1))
        Assert.AreEqual(False, Board.ValidPosition(5, -1))
        Assert.AreEqual(False, Board.ValidPosition(-1, 4))
        Assert.AreEqual(False, Board.ValidPosition(8, 1))
        Assert.AreEqual(False, Board.ValidPosition(8, 8))

    End Sub

    '''<summary>
    '''CellStone のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub CellStoneTest()
        Dim target As Board = New Board()
        target.CellStone(0, 0) = Board.BLACK
        Assert.AreEqual(Board.BLACK, target.CellStone(0, 0))
        Assert.AreEqual(Board.EMPTY, target.CellStone(3, 2))
        Assert.AreEqual(Board.WHITE, target.CellStone(4, 4))
        Assert.AreEqual(Board.BLACK, target.CellStone(4, 3))
    End Sub

    '''<summary>
    '''IsGameEnd のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub IsGameEndTest()
        Dim target As Board = New Board()
        Assert.AreEqual(False, target.IsGameEnd)
        target.IsGameEnd = True
        Assert.AreEqual(True, target.IsGameEnd)
    End Sub

    '''<summary>
    '''Turn のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub TurnTest()
        Dim target As Board = New Board()
        Assert.AreEqual(Board.BLACK, target.Turn)
    End Sub
End Class
