﻿Public Class computerPlayer

    Private _AI As AI.computerAI

    Public Sub ChangeAI(ByVal AI As AI.computerAI, ByVal Color As Integer)
        _AI = AI
        MyColor = Color
        If _AI Is Nothing Then
            MyColor = Board.EMPTY
        End If
    End Sub

    Public Property MyColor As Integer

    Public Sub DoPut(ByVal nowBoard As Board)

        _AI.Initialize(nowBoard)

        Dim bestX As Integer = -1
        Dim bestY As Integer = -1
        Dim bestEvaluation As Integer = -9999
        For x As Integer = 0 To Board.SIZE_X - 1
            For y As Integer = 0 To Board.SIZE_Y - 1
                If nowBoard.CanPut(x, y) Then
                    Dim virtualBoard As Board = New Board(nowBoard)
                    virtualBoard.Put(x, y)
                    virtualBoard.TurnChange()
                    Dim evaluation As Integer = _AI.EvaluationValue(virtualBoard)
                    If evaluation > bestEvaluation Then
                        bestX = x
                        bestY = y
                        bestEvaluation = evaluation
                    End If
                End If
            Next
        Next
        Debug.Assert(bestX <> -1)
        Debug.Assert(bestY <> -1)
        Debug.Assert(bestEvaluation <> -9999)
        nowBoard.Put(bestX, bestY)

    End Sub




End Class
