﻿Imports ReversiGame

Imports Microsoft.VisualStudio.TestTools.UnitTesting

Imports ReversiGame.AI.Level2



'''<summary>
'''MidEvaluatorTest のテスト クラスです。すべての
'''MidEvaluatorTest 単体テストをここに含めます
'''</summary>
<TestClass()> _
Public Class MidEvaluatorTest


    Private testContextInstance As TestContext

    '''<summary>
    '''現在のテストの実行についての情報および機能を
    '''提供するテスト コンテキストを取得または設定します。
    '''</summary>
    Public Property TestContext() As TestContext
        Get
            Return testContextInstance
        End Get
        Set(value As TestContext)
            testContextInstance = Value
        End Set
    End Property

#Region "追加のテスト属性"
    '
    'テストを作成するときに、次の追加属性を使用することができます:
    '
    'クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
    '<ClassInitialize()>  _
    'Public Shared Sub MyClassInitialize(ByVal testContext As TestContext)
    'End Sub
    '
    'クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
    '<ClassCleanup()>  _
    'Public Shared Sub MyClassCleanup()
    'End Sub
    '
    '各テストを実行する前にコードを実行するには、TestInitialize を使用
    '<TestInitialize()>  _
    'Public Sub MyTestInitialize()
    'End Sub
    '
    '各テストを実行した後にコードを実行するには、TestCleanup を使用
    '<TestCleanup()>  _
    'Public Sub MyTestCleanup()
    'End Sub
    '
#End Region


    '''<summary>
    '''IdxLine のテスト
    '''</summary>
    <TestMethod()> _
    Public Sub IdxLineTest()
        Assert.AreEqual(3280, MidEvaluator.IdxLine({0, 0, 0, 0, 0, 0, 0, 0}))
        Assert.AreEqual(5494, MidEvaluator.IdxLine({1, 0, 0, 0, 1, 0, 0, 0}))
        Assert.AreEqual(0, MidEvaluator.IdxLine({-1, -1, -1, -1, -1, -1, -1, -1}))
        Assert.AreEqual(1603, MidEvaluator.IdxLine({-1, 1, -1, 0, 1, 0, -1, 0}))

    End Sub
 

    '''<summary>
    '''GenerateEdge のテスト
    '''</summary>
    <TestMethod(), _
     DeploymentItem("ReversiGame.exe")> _
    Public Sub GenerateEdgeTest()
        Dim target As MidEvaluator_Accessor = New MidEvaluator_Accessor() ' TODO: 適切な値に初期化してください
        Dim edge() As Integer = {0, 0, 0, 0, 0, 0, 0, 0}
        target.GenerateEdge(edge, 0)
        Assert.IsNotNull(target.EdgeTable(0))
        Assert.AreEqual(8, target.EdgeTable(0)(DiscColor.WHITE).Stable)
        Assert.AreEqual(0, target.EdgeTable(0)(DiscColor.BLACK).Stable)
        Assert.AreEqual(0, target.EdgeTable(0)(DiscColor.WHITE).CMove)
        Assert.AreEqual(0, target.EdgeTable(0)(DiscColor.BLACK).CMove)
        Assert.AreEqual(0, target.EdgeTable(3280)(DiscColor.BLACK).CMove)

    End Sub

    '''<summary>
    '''evalEdge のテスト
    '''</summary>
    <TestMethod(), _
     DeploymentItem("ReversiGame.exe")> _
    Public Sub evalEdgeTest()
        Dim target As MidEvaluator_Accessor = New MidEvaluator_Accessor() ' TODO: 適切な値に初期化してください
        Dim line() As Integer = {0, 0, 0, 0, 0, 0, 0, 0}
        Dim actual As EdgeParam
        actual = target.evalEdge(line, DiscColor.BLACK)
        Assert.AreEqual(0, actual.Stable)
        Assert.AreEqual(0, actual.CMove)
        Assert.AreEqual(0, actual.Wing)
        Assert.AreEqual(0, actual.Mountain)
        line = {0, 1, 0, 0, 0, 0, 1, 0}
        actual = target.evalEdge(line, DiscColor.BLACK)
        Assert.AreEqual(0, actual.Stable)
        Assert.AreEqual(2, actual.CMove)
        Assert.AreEqual(0, actual.Wing)
        Assert.AreEqual(0, actual.Mountain)

    End Sub
End Class
