﻿Public Class KomaUtil

    Shared senteKomas As Koma() = {Koma.SenteHI, Koma.SenteKI, Koma.SenteLI, Koma.SenteNI, Koma.SenteZO}
    Shared goteKomas As Koma() = {Koma.GoteHI, Koma.GoteKI, Koma.GoteLI, Koma.GoteNI, Koma.GoteZO}
    Shared codes As String() = {". ", "LI", "KI", "ZO", "HI", "NI"}

    Public Shared Function OppositeKoma(ByVal komaVal As Koma) As Koma
        If komaVal = Koma.Empty Then
            Return Koma.Empty
        End If
        If komaVal >= 6 Then
            Return komaVal - 5
        Else
            Return komaVal + 5
        End If
    End Function

    Public Shared Function CaputringKoma(ByVal komaVal As Koma) As Koma
        If komaVal = Koma.GoteNI Then
            Return Koma.SenteHI
        End If
        If komaVal = Koma.SenteNI Then
            Return Koma.GoteHI
        End If
        Return OppositeKoma(komaVal)
    End Function

    Public Shared Function IsSente(ByVal komaVal As Koma) As Boolean
        Return senteKomas.Contains(komaVal)
    End Function

    Public Shared Function IsGote(ByVal komaVal As Koma) As Boolean
        Return goteKomas.Contains(komaVal)
    End Function

    Public Shared Function KomaSide(ByVal komaVal As Koma) As Side
        If IsSente(komaVal) Then
            Return Side.sente
        End If
        If IsGote(komaVal) Then
            Return Side.gote
        End If
        Return Side.None
    End Function

    Public Shared Function KomaSideKoma(ByVal komaval As Koma) As Koma
        If IsSente(komaval) Then
            Return Koma.Sente
        ElseIf IsGote(komaval) Then
            Return Koma.Gote
        End If
        Return Koma.Empty
    End Function

    Public Shared Function KomaKind(ByVal komaVal As Koma) As Koma
        If IsGote(komaVal) Then
            Return komaVal - Koma.Gote
        End If
        Return komaVal
    End Function

    Public Shared Function GetKomaFromCode(ByVal code As String, ByVal sideVal As Side) As Koma
        For i As Integer = 0 To codes.Count - 1
            If codes(i) = code Then
                If sideVal = Side.sente Then
                    Return DirectCast(i, Koma)
                Else
                    Return DirectCast(i + codes.Count - 1, Koma)
                End If
            End If
        Next
        Return Koma.Empty
    End Function

    Public Shared Function ToCode(ByVal komaVal As Koma) As String
        Dim value = komaVal
        If IsGote(komaVal) Then
            value = komaVal - (codes.Count - 1)
        End If
        Return codes(value)
    End Function
End Class
