import os, subprocess, sys

class TooSlow(Exception):
    pass

def go(args):
    p = subprocess.Popen(args, stdout=subprocess.DEVNULL)
    _, status, rusage = os.wait4(p.pid, 0)
    if status:
        raise TooSlow()
    return rusage.ru_utime + rusage.ru_stime, rusage.ru_maxrss

def r5():
    multiplier = 1
    yield from (0, 1, 2, 3, 4, 6)
    while True:
        for x in (10, 16, 25, 40, 63):
            yield x * multiplier
        multiplier *= 10

if __name__ == "__main__":
    mode = sys.argv[1]
    args = ["softlimit", "-t", "1"] + sys.argv[2:]
    l = []
    for i in r5():
        try:
            time, space = go(args + [str(i)])
            l.append((i, time, space))
        except TooSlow:
            break

    if mode == "time":
        for i, time, _ in l:
            print(i, time)
    elif mode == "space":
        for i, _, space in l:
            print(i, space)
    elif mode == "max":
        print(*l[-1])
