entrypoint: exe: enableJIT:
{ nixpkgs ? import <nixpkgs> {}, jelly ? null }:
let
  inherit (nixpkgs.pkgs)
  fetchFromGitLab stdenv
  pkg-config libffi stb
  pypy pypyPackages;
  # https://foss.heptapod.net/pypy/pypy/
  pypySrc = fetchFromGitLab {
    domain = "foss.heptapod.net";
    owner = "pypy";
    repo = "pypy";
    # release candidate from branch release-pypy3.8-v7.x
    rev = "90fd9ed34d52181de59cbfff863719472b05418e";
    sha256 = "03cshgvh8qcsyac4q4vf0sbvcm1m2ikgwycwip4cc7sw9pzpw6a3";
  };
in
  let
    opt = if enableJIT then "jit" else "2";
  in stdenv.mkDerivation {
    name = exe;

    src = builtins.filterSource
      (path: type: baseNameOf path == entrypoint
       || builtins.match ".*cammylib.*" path != null)
      ./.;

    buildInputs = [
      # always required
      pypySrc pkg-config stb
      pypy pypyPackages.py
      # only required for JIT
      pypyPackages.pytest libffi
    ];

    JELLY_PATH = "${jelly}/bin/jelly";

    buildPhase = ''
      source $stdenv/setup
      mkdir -p ./rpython/_cache
      cp -r ${pypySrc}/rpython .
      chmod -R u+w rpython/
      # Do the actual translation.
      ${pypy}/bin/pypy -mrpython -O${opt} ${entrypoint}
      '';

    installPhase = ''
      mkdir -p $out/bin/
      cp ${exe} $out/bin/
      '';

    separateDebugInfo = true;
  }

