import os.path

from cammylib.parser import parse


class MissingAtom(Exception):
    "An atom is missing from a hive."

    def __init__(self, atom):
        self.atom = atom


class Hive(object):
    "A self-referential collection of S-expressions."

    def __init__(self, hivepath):
        self.hivepath = hivepath
        self.exprs = {}

    def load(self, atom):
        if atom in self.exprs:
            return self.exprs[atom]

        # print("Loading", atom)
        filename = atom + ".cammy"
        fullpath = os.path.join(self.hivepath, filename)
        try:
            with open(fullpath, "r") as handle:
                sexp, trail = parse(handle.read())
                sexp = sexp.canonicalize(self)
                self.exprs[atom] = sexp
                # print("Loaded", atom, sexp)
                return sexp
        except IOError:
            raise MissingAtom(atom)
