from cammylib.sexp import Atom, Functor, Hole


class CammyParser(object):

    def __init__(self, s):
        self._i = 0
        self._s = s

    def position(self):
        return self._i

    def eatWhitespace(self):
        while self._i < len(self._s) and self._s[self._i] in (" ", "\n"):
            self._i += 1

    def canAndDoesEat(self, c):
        if self._s[self._i] == c:
            self._i += 1
            return True
        else:
            return False

    def takeName(self):
        start = self._i
        while self._i < len(self._s) and self._s[self._i] not in (")", "(", " ", "\n"):
            self._i += 1
        stop = self._i
        return self._s[start:stop]

    def takeExpression(self):
        self.eatWhitespace()
        if self.canAndDoesEat('('):
            return self.startFunctor()
        else:
            symbol = self.takeName()
            if symbol.startswith("@"):
                try:
                    return Hole(int(symbol[1:]))
                except ValueError:
                    return Atom(symbol)
            return Atom(symbol)

    def startFunctor(self):
        head = self.takeName()
        self.eatWhitespace()
        args = []
        while not self.canAndDoesEat(')'):
            args.append(self.takeExpression())
            self.eatWhitespace()
        return Functor(head, args)


def parse(s):
    parser = CammyParser(s)
    sexp = parser.takeExpression()
    # Parser is now fast-forwarded to the end of the S-expression, so we can
    # slice from that point and get the docstring/etc.
    trail = s[parser.position():]
    return sexp, trail
