# Inspired by https://www.pypy.org/posts/2018/11/guest-post-implementing-calculator-repl-6271483514675006846.html

import sys

from rpython.rlib.rfile import create_stdio

from cammylib.arrows import BuildProblem, T
from cammylib.hive import Hive, MissingAtom
from cammylib.jelly import jellify
from cammylib.parser import parse
from cammylib.types import ConstraintStore, TypeExtractor, UnificationFailed

LINE_BUFFER_LENGTH = 1024

def command(hive, code, line):
    # XXX code e: Edit a file
    # os.system("$EDITOR")
    if code == "!":
        # Evaluate an element.
        sexp, trail = parse(line)
        sexp = sexp.canonicalize(hive)
        sexp = jellify(sexp)
        arrow = sexp.buildArrow()
        print arrow.run(T()).asStr()

def repl(hive, stdin, stdout):
    while True:
        stdout.write("> ")
        line = stdin.readline(LINE_BUFFER_LENGTH)
        if not line:
            # Empty read means EOF.
            break
        if line.startswith(":"):
            if len(line) < 2:
                print "Not a full command"
            command(hive, line[1], line[3:])
            continue
        sexp, trail = parse(line)
        print "Got:", line
        print "S-expression:", sexp.asStr()
        print "Trail:", trail
        try:
            sexp = sexp.canonicalize(hive)
            print "Canonicalized:", sexp.asStr()
        except MissingAtom as ma:
            print "Couldn't canonicalize S-expression; missing atom:", ma.atom
        sexp = jellify(sexp)
        print "Jellified:", sexp.asStr()
        try:
            arrow = sexp.buildArrow()
            print "Arrow:", arrow
            cs = ConstraintStore()
            domain, codomain = arrow.types(cs)
            extractor = TypeExtractor(cs)
            for i, (gdom, gcod) in enumerate(cs.knownGivens):
                print "Given @%d : %s -> %s" % (i,
                        extractor.extract(gdom),
                        extractor.extract(gcod))
            print "Type:", extractor.extract(domain), "->", extractor.extract(codomain)
        except BuildProblem as bp:
            print "Couldn't build arrow:", bp.message
        except UnificationFailed as uf:
            print "Couldn't check type:", uf.message
    return 0

def main(argv):
    hivepath = argv[-1]
    hive = Hive(hivepath)
    stdin, stdout, stderr = create_stdio()
    return repl(hive, stdin, stdout)

def target(driver, *args):
    driver.exe_name = "cammy-repl"
    return main, None

if __name__ == "__main__":
    main(sys.argv)
