# radiru_rec.py

「らじる☆らじる」録音のためのシェルスクリプト生成器

## Usage

  python radiru_rec.py [OPTIONS] <CHANNEL> [BEGIN_DATE] <BEGIN_TIME> [END_DATE] <END_TIME|RECORDING_TIME> 

    <> : 必須
    [] : 任意(省略可能)

## Description

NHKのネットラジオ「らじる☆らじる」を録音するためのシェルスクリプトを生成し，at コマンドに登録します。
こじまみつひろ氏作の radiru_rec2.py (*1) に対し，以下の変更を施しています。

* 文字コードをEUC-JPからUTF-8に変更
* ストリーミングデータのURLを変更
* 録音形式を MP3 から AAC (拡張子 .m4a) に変更
* mplayer(ストリーミングデータから録音), lame(MP3生成) の代わりに avconv を使用
* 録音時間経過後に停止する方法を，timeout コマンドに変更

(*1) http://plamo.linet.gr.jp/wiki/index.php?diary%2FKojima%2F2012-08-29

## Requirement

* Python
* avconv (libav)
* GNU coreutils (timeout コマンド)

## Option

Usage中 <>で括られたオプションは必須，[]で括られたオプションは任意です。

### CHANNEL

*必須*  
録音する局を指定します。r1, r2 または fm のうちどれか一つを指定します。

* r1 -- AMラジオ放送第1
* r2 -- AMラジオ放送第2
* fm -- FMラジオ放送

いずれも，東京局のみ対応しています

### BEGIN_DATE

*任意*
録音開始日(BEGIN_DATE)を指定します。
省略された場合はコマンドを実行した当日を指定したものとみなします。
書式は YYYY/MM/DD (YYYY:年, MM:月, DD:日)です。

### BEGIN_TIME

*必須*
録音開始時刻を指定します。書式は hh:mm (hh: 時(24H), mm: 分)です。

### END_TIME, RECORDING_TIME

*どちらか必須*
録音終了時刻(END_TIME)または録音時間(RECORDING_TIME)を指定します。

### OPTIONS

*任意*

* -t <タイトル> -- 録音のタイトルを指定する。
* -d -- 日毎の繰り返しを行う。繰り返し回数は -r オプションで指定する (-d を指定した場合、-r オプションは必須)。
* -w -- 週毎の繰り返しを行う。繰り返し回数は -r オプションで指定する (-w を指定した場合、-r オプションは必須)。
* -r <n> -- 繰り返し回数(n回)を指定する。
* -n -- タイトルに連番を付与する。繰り返し録音を指定した場合は、その回数に応じて連番が1ずつ増加する。

