package org.pulpdust.wtb;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

import android.net.Uri;
import android.os.Bundle;
import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;

public class WTBActivity extends Activity {

	EditText urlbar;
	Spinner from;
	Spinner to;
	Button okbutton;
	String service;
	String object;
	String[] subject;
	List<String> froms;
	List<String> tos;
	ArrayAdapter<String> afroms;
	ArrayAdapter<String> atos;
	int from_pos = 0;
	int to_pos = 8;
	int from_cur;
	int to_cur;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		readProps();
		if (Intent.ACTION_SEND.equals(getIntent().getAction())){
			object = getIntent().getExtras().getCharSequence(Intent.EXTRA_TEXT).toString();
		}
		setContentView(R.layout.activity_wtb);
		
		urlbar = (EditText) findViewById(R.id.editText1);
		urlbar.setText(object);
		
		from = (Spinner) findViewById(R.id.spinner1);
		from.setAdapter(afroms = setLangs(froms = new ArrayList<String>()));
		from.setSelection(from_pos);
		from_cur = from.getSelectedItemPosition();
		from.setOnItemSelectedListener(new OnItemSelectedListener(){

			@Override
			public void onItemSelected(AdapterView<?> av, View v,
					int pos, long id) {
				if (pos != 8){
					to.setSelection(8);
				} else if (pos == 8 && to_cur == 8){
					to.setSelection(0);
				}
				from_cur = pos;
			}

			@Override
			public void onNothingSelected(AdapterView<?> arg0) {
				// TODO Auto-generated method stub
				
			}
			
		});
		
		to = (Spinner) findViewById(R.id.spinner2);
		to.setAdapter(atos = setLangs(tos = new ArrayList<String>()));
		to.setSelection(to_pos);
		to_cur = to.getSelectedItemPosition();
		to.setOnItemSelectedListener(new OnItemSelectedListener(){

			@Override
			public void onItemSelected(AdapterView<?> av, View v,
					int pos, long id) {
				if (pos != 8){
					from.setSelection(8);
				} else if (pos == 8 && from_cur == 8){
					from.setSelection(0);
				}
				to_cur = pos;
			}

			@Override
			public void onNothingSelected(AdapterView<?> arg0) {
				// TODO Auto-generated method stub
				
			}
			
		});
		
		okbutton = (Button) findViewById(R.id.button1);
		okbutton.setOnClickListener(new OnClickListener(){

			@Override
			public void onClick(View v) {
				if (!urlbar.getText().toString().equals("")){
					Intent i;
					try {
						i = new Intent("android.intent.action.VIEW",
								Uri.parse(String.format(service, 
										subject[from.getSelectedItemPosition()], 
										subject[to.getSelectedItemPosition()]) 
										+ URLEncoder.encode(URLDecoder.decode(urlbar.getText().toString(), "UTF-8"), "UTF-8")));
//						i.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
						startActivity(i);
					} catch (UnsupportedEncodingException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					writeProps();
					finish();
				}
			}
			
		});
	}
	
	public ArrayAdapter<String> setLangs(List<String> ls){
		ArrayAdapter<String> aa = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, ls);
		aa.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
		aa.add(getString(R.string.en));
		aa.add(getString(R.string.zh));
		aa.add(getString(R.string.ko));
		aa.add(getString(R.string.fr));
		aa.add(getString(R.string.de));
		aa.add(getString(R.string.es));
		aa.add(getString(R.string.pt));
		aa.add(getString(R.string.it));
		aa.add(getString(R.string.ja));
		return aa;
	}

	public void writeProps(){
		SharedPreferences sp = getPreferences(MODE_PRIVATE);
		SharedPreferences.Editor pe = sp.edit();
		pe.putInt("from_pos", from.getSelectedItemPosition());
		pe.putInt("to_pos", to.getSelectedItemPosition());
		pe.commit();
	}
	public void readProps(){
		SharedPreferences sp = getPreferences(MODE_PRIVATE);
		from_pos = sp.getInt("from_pos", 0);
		to_pos = sp.getInt("to_pos", 8);
		service = "http://honyaku.yahoofs.jp/url_result?ieid=%s&oeid=%s&both=T&setting=for%%3D0&url=";
		subject = new String[]{"en", "zh", "ko", "fr", "de", "es", "pt", "it", "ja"};
		object = "";
	}

//	@Override
//	public boolean onCreateOptionsMenu(Menu menu) {
//		// Inflate the menu; this adds items to the action bar if it is present.
//		getMenuInflater().inflate(R.menu.wtb, menu);
//		return true;
//	}

}
