/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package arithmetic;

import java.util.List;
import mapping.Mapping;

/**
 *
 * @author mtomono
 */
public class Mod<T extends Number> implements Mapping<List<T>, Number> {
    
    public static int mod(int value, int mod) {
        return (value %= mod)<0? mod + value : value;
    }
    
    public static long mod(long value, long mod) {
        return (value %= mod)<0? mod + value : value;
    }
    
    public static double mod(double value, double mod) {
        return (value %= mod)<0? mod + value : value;
    }
    
    @Override
    public Number of(List<T> target) {
        assert target.size() == 2;
        assert target.get(0) != null;
        assert target.get(1) != null;
        assert target.get(0) instanceof Number;
        assert target.get(1) instanceof Number;
        if (target.get(0) instanceof Double || target.get(1) instanceof Double)
            return mod(target.get(0).doubleValue(), target.get(1).doubleValue());
        else if (target.get(0) instanceof Long || target.get(1) instanceof Long)
            return mod(target.get(0).longValue(), target.get(1).longValue());
        else 
            return mod(target.get(0).intValue(), (int)target.get(1).intValue());
    }

    @Override
    public boolean isReady(List<T> target) {
        return !target.get(1).equals(0);
    }
}
