/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package bitmap;

import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;

/**
 *
 * @author mtomono
 */
public class BitMap<T> extends AbstractSet<T> {
    BitSet body;
    ReferenceMap<T> reference;
    
    public BitMap(ReferenceMap<T> reference) {
        this.reference = reference;
        this.body = new BitSet(reference.size());
    }
    
    public BitMap(ReferenceMap<T> reference, Collection<? extends T> initial) {
        this(reference);
        addAll(initial);
    }
    
    @Override
    public Iterator<T> iterator() {
        return new BitMapIterator<>(body, reference);
    }
    
    @Override
    public boolean add(T o) {
        if (contains(o))
            return false;
        if (!reference.contains(o))
            reference.add(o);
        body.set(reference.resolve(o));
        return true;
    }
    
    boolean isComparable(Collection<?> c) {
        return c instanceof BitMap && ((BitMap)c).reference == this.reference;
    }
    
    static boolean aContainsB(BitSet a, BitSet b) {
        BitSet clone = (BitSet)b.clone();
        clone.andNot(a);
        return clone.isEmpty();
    }
    
    @Override
    public final boolean addAll(Collection<? extends T> c) {
        if (isComparable(c)) {
            if (aContainsB(this.body, ((BitMap)c).body))
                return false;
            this.body.or(((BitMap)c).body);
            return true;
        } else {
            boolean retval = false;
            for (T o : c) {
                if (add(o))
                    retval = true;
            }
            return retval;
        }
    }
    
    @Override
    public void clear() {
        body.clear();
    }
    
    @Override
    public boolean contains(Object o) {
        if (!reference.contains(o))
            return false;
        return body.get(reference.resolve((T)o));
    }
    
    @Override
    public boolean containsAll(Collection<?> c) {
        if (isComparable(c))
            return aContainsB(this.body, ((BitMap)c).body);
        for (Object o : c) {
            if (!contains((T)o))
                return false;
        }
        return true;
    }
    
    @Override
    public boolean isEmpty() {
        return body.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        if (!contains((T)o))
            return false;
        body.clear(reference.resolve((T)o));
        return true;
    }
    
    @Override
    public boolean removeAll(Collection<?> c) {
        if (isComparable(c)) {
            if (!this.body.intersects(((BitMap)c).body))
                return false;
            this.body.andNot(((BitMap)c).body);
            return true;
        }
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (isComparable(c)) {
            if (aContainsB(((BitMap)c).body, this.body))
                return false;
            this.body.and(((BitMap)c).body);
            return true;
        }
        boolean retval = false;
        for (T o : this) {
            if (!c.contains(o)) {
                this.remove(o);
                retval = true;
            }
        }
        return retval;
    }

    @Override
    public int size() {
        return this.body.cardinality();
    }


    @Override
    public Object[] toArray() {
        Object[] retval = new Object[size()];
        int i = 0;
        for (T o : this) {
            retval[i++] = o;
        }
        return retval;
    }
}
