/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package collection;

import java.util.List;
import java.util.ListIterator;

/**
 *
 * @author mtomono
 */
public class ArrayListIterator<T> implements ListIterator<T> {
    List<T> body;
    int index;
    
    public ArrayListIterator(List<T> target) {
        this(target, 0);
    }
    
    public ArrayListIterator(List<T> target, int at) {
        this.body = target;
        this.index = at;
    }
    
    @Override
    public boolean hasNext() {
        return index < body.size();
    }

    @Override
    public T next() {
        return body.get(index++);
    }

    @Override
    public void remove() {
        this.body.remove(index);
    }

    @Override
    public boolean hasPrevious() {
        return index > 0;
    }

    @Override
    public T previous() {
        return this.body.get(--index);
    }

    @Override
    public int nextIndex() {
        return index;
    }

    @Override
    public int previousIndex() {
        return index - 1;
    }

    @Override
    public void set(T arg0) {
        this.body.set(index, arg0);
    }

    @Override
    public void add(T arg0) {
        this.body.add(index, arg0);
    }
}
