/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package collection;
import arithmetic.Sub;
import collection.view.ListView;
import collection.view.OffsetView;
import java.util.ArrayList;
import java.util.List;
import mapping.*;
import orderedSet.Range;
import text.Format;

/**
 *
 * @author mtomono
 */
public class At<T> implements Mapping<List<T>, T> {
    Mapping<? super List<T>, Integer> body;
    public static <T> At<T> NOW() {
        return At.<T>c(0);
    }
   public static <T> At<T> PRE() {
        return At.<T>c(-1);
    }
    public static <T> At<T> LAST() {
        return new At<>(new o<>(new Id<Integer>(), new MOp<>(new Sub<>(), new ToSize<T>(), new Const<>(1))));
    }

    public static At NOW = At.NOW();
    public static At PRE = At.PRE();
    public static At LAST = At.LAST();
 
    public static <T> List<Mapping<List<T>, T>> batch(Range<Integer> range) {
        return batch(range.getStart(), range.getEnd());
    }
    public static <T> List<Mapping<List<T>, T>> batch(int from, int to) {
        List<Mapping<List<T>, T>> retval = new ArrayList<>();
        for (int i = from; i < to; i++) {
            retval.add(At.<T>c(i));
        }
        return new OffsetView<>(retval, from);
    }
    
    static public <T> At<T> c(int position) {
        return new At<>(new Const<>(position));
    }
    
    public At(Mapping<? super List<T>, Integer> body) {
        this.body = body;
    }
    
@Override
    public boolean isReady(List<T> target) {
        int position = body.of(target);
        if (target instanceof ListView) 
            return ((ListView)target).isReady(position);
        else 
            return 0 <= position && position < target.size();
    }
    
    @Override
    public T of(List<T> target) {
        return target.get(body.of(target));
    }
    
    @Override
    public String toString() {
        return Format.function("At", "" + body);
    }
}
